/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.base.entity;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fhs.core.trans.anno.Trans;
import com.fhs.core.trans.vo.TransPojo;
import com.kdgcsoft.iframe.web.base.embed.dict.DicType;
import com.kdgcsoft.iframe.web.base.entity.BaseDictItem;
import com.kdgcsoft.iframe.web.common.entity.BaseEntity;
import com.kdgcsoft.iframe.web.common.utils.TreeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;

@TableName(value="base_dict")
public class BaseDict
extends BaseEntity
implements TransPojo,
Serializable {
    private static final long serialVersionUID = 6163078071553989320L;
    @TableId(type=IdType.ASSIGN_ID)
    private Long dictId;
    @NotBlank(message="\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String dictCode;
    @NotBlank(message="\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String dictName;
    @TableField(exist=false)
    private String nameWithCode;
    @Trans(type="dictionary", key="DicType")
    private DicType dictType = DicType.LIST;
    private Integer embed = 0;
    private String rmk;
    private Integer ordNo;
    @TableField(exist=false)
    private List<BaseDictItem> items = new ArrayList<BaseDictItem>();

    public String getNameWithCode() {
        return this.dictName + " [" + this.dictCode + "]";
    }

    public void addItem(String text, String value, int order) {
        if (this.items == null) {
            this.items = new ArrayList<BaseDictItem>();
        }
        this.items.add(new BaseDictItem().setText(text).setValue(value).setOrdNo(order));
    }

    public List<String> getChildrenValues(String value, boolean includeSelf) {
        Optional<BaseDictItem> result = this.items.stream().filter(item -> item.getValue().equals(value)).findFirst();
        if (result.isPresent()) {
            BaseDictItem baseDictItem = result.get();
            List childIds = TreeUtil.getChildIds(this.items, (Object)baseDictItem.getDictItemId(), (boolean)includeSelf);
            return this.items.stream().filter(item -> ObjectUtil.contains((Object)childIds, (Object)item.getDictItemId())).map(BaseDictItem::getValue).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public BaseDict setDictId(Long dictId) {
        this.dictId = dictId;
        return this;
    }

    public BaseDict setDictCode(String dictCode) {
        this.dictCode = dictCode;
        return this;
    }

    public BaseDict setDictName(String dictName) {
        this.dictName = dictName;
        return this;
    }

    public BaseDict setNameWithCode(String nameWithCode) {
        this.nameWithCode = nameWithCode;
        return this;
    }

    public BaseDict setDictType(DicType dictType) {
        this.dictType = dictType;
        return this;
    }

    public BaseDict setEmbed(Integer embed) {
        this.embed = embed;
        return this;
    }

    public BaseDict setRmk(String rmk) {
        this.rmk = rmk;
        return this;
    }

    public BaseDict setOrdNo(Integer ordNo) {
        this.ordNo = ordNo;
        return this;
    }

    public BaseDict setItems(List<BaseDictItem> items) {
        this.items = items;
        return this;
    }

    public Long getDictId() {
        return this.dictId;
    }

    public String getDictCode() {
        return this.dictCode;
    }

    public String getDictName() {
        return this.dictName;
    }

    public DicType getDictType() {
        return this.dictType;
    }

    public Integer getEmbed() {
        return this.embed;
    }

    public String getRmk() {
        return this.rmk;
    }

    public Integer getOrdNo() {
        return this.ordNo;
    }

    public List<BaseDictItem> getItems() {
        return this.items;
    }
}

