/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.module;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.fhs.trans.service.impl.DictionaryTransService;
import com.kdgcsoft.iframe.web.base.embed.dict.DicType;
import com.kdgcsoft.iframe.web.base.embed.dict.MenuOpenType;
import com.kdgcsoft.iframe.web.base.entity.BaseDict;
import com.kdgcsoft.iframe.web.base.entity.BaseDictItem;
import com.kdgcsoft.iframe.web.base.entity.BaseMenu;
import com.kdgcsoft.iframe.web.base.entity.BaseParam;
import com.kdgcsoft.iframe.web.base.service.BaseModuleService;
import com.kdgcsoft.iframe.web.common.anno.EmbedDict;
import com.kdgcsoft.iframe.web.common.anno.EmbedMenu;
import com.kdgcsoft.iframe.web.common.anno.EmbedParam;
import com.kdgcsoft.iframe.web.common.config.IFrameProperties;
import com.kdgcsoft.iframe.web.common.consts.ComConst;
import com.kdgcsoft.iframe.web.common.consts.YesNo;
import com.kdgcsoft.iframe.web.common.interfaces.IEmbedDic;
import com.kdgcsoft.iframe.web.common.interfaces.IEmbedMenu;
import com.kdgcsoft.iframe.web.common.interfaces.IEmbedParam;
import com.kdgcsoft.iframe.web.module.exception.ModuleException;
import com.kdgcsoft.iframe.web.module.model.ModuleDic;
import com.kdgcsoft.iframe.web.module.model.ModuleMenu;
import com.kdgcsoft.iframe.web.module.model.ModuleParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ModuleManager {
    private static final Logger log = LoggerFactory.getLogger(ModuleManager.class);
    private final PathMatchingResourcePatternResolver pathResolver = new PathMatchingResourcePatternResolver();
    private ApplicationContext applicationContext;
    private IFrameProperties iFrameProperties;
    private BaseModuleService baseModuleService;
    private DictionaryTransService dictionaryTransService;
    private TimeInterval timer = new TimeInterval();
    private List<ModuleDic> dicList = new ArrayList<ModuleDic>();
    private List<ModuleParam> paramsList = new ArrayList<ModuleParam>();
    private List<ModuleMenu> menuList = new ArrayList<ModuleMenu>();
    private final Map<String, BaseParam> paramsMap = new HashMap<String, BaseParam>();

    public ModuleManager() {
        this.applicationContext = SpringUtil.getApplicationContext();
        this.baseModuleService = (BaseModuleService)this.applicationContext.getBean(BaseModuleService.class);
        this.dictionaryTransService = (DictionaryTransService)this.applicationContext.getBean(DictionaryTransService.class);
    }

    @PostConstruct
    private void init() {
        log.info("ModuleManager\u5f00\u59cb\u626b\u63cf\u5e76\u8fdb\u884c\u540c\u6b65.");
        this.loadEmbedDics();
        this.loadEmbedParams();
        this.loadEmbedMenus();
        this.syncEmbedParams();
        this.syncEmbedDic();
        this.syncEmbedMenus();
        this.refreshParamsMap();
        log.info("ModuleManager\u5de5\u4f5c\u5b8c\u6210.");
    }

    private void loadEmbedDics() {
        log.debug("\u5f00\u59cb\u626b\u63cf\u5185\u7f6e\u5b57\u5178:\u626b\u63cf\u4f7f\u7528@{}\u6ce8\u89e3\u5e76\u5b9e\u73b0\u4e86{}\u63a5\u53e3\u7684\u679a\u4e3e\u7c7b ...", (Object)EmbedDict.class.getSimpleName(), (Object)IEmbedDic.class.getSimpleName());
        ClassUtil.scanPackageByAnnotation((String)"com.kdgcsoft", EmbedDict.class).forEach(cls -> {
            if (IEmbedDic.class.isAssignableFrom((Class<?>)cls) && cls.isEnum()) {
                EmbedDict ann = cls.getAnnotation(EmbedDict.class);
                if (ann != null) {
                    String code;
                    String string = code = StrUtil.isEmpty((CharSequence)ann.code()) ? cls.getSimpleName() : ann.code();
                    if (this.existDic(code)) {
                        throw new ModuleException(StrUtil.format((CharSequence)"\u5b57\u5178\u7f16\u7801\u91cd\u590d:\u7f16\u7801[{}],\u7c7b\u540d[{}]", (Object[])new Object[]{code, ann.getClass().getName()}));
                    }
                    String name = StrUtil.isEmpty((CharSequence)ann.value()) ? cls.getSimpleName() : ann.value();
                    String description = StrUtil.isEmpty((CharSequence)ann.description()) ? cls.getName() : ann.description();
                    ModuleDic mDic = new ModuleDic().setCode(code).setName(name).setDescription(description);
                    for (Object a : cls.getEnumConstants()) {
                        IEmbedDic i = (IEmbedDic)a;
                        Enum e = (Enum)a;
                        mDic.addOption(e.name(), i.text());
                    }
                    this.dicList.add(mDic);
                    log.debug("\u52a0\u8f7d\u5185\u7f6e\u5b57\u5178[code='{}',name='{}'] \u4ece {}", new Object[]{mDic.getCode(), mDic.getName(), cls.getName()});
                } else {
                    log.warn("\u626b\u63cf\u5230\u5185\u7f6e\u5b57\u5178:[{}],\u8bf7\u4f7f\u7528\u6ce8\u89e3[@{}]\u53bb\u5f00\u542f\u8be5\u5b57\u5178.", (Object)cls.getName(), (Object)EmbedDict.class.getName());
                }
            }
        });
        log.info("\u5171\u626b\u63cf\u5230:{}\u4e2a\u5185\u7f6e\u5b57\u5178.", (Object)this.dicList.size());
    }

    private void loadEmbedParams() {
        log.debug("\u5f00\u59cb\u626b\u63cf\u5185\u7f6e\u53c2\u6570:\u626b\u63cf\u4f7f\u7528@{}\u6ce8\u89e3\u5e76\u5b9e\u73b0\u4e86{}\u63a5\u53e3\u7684\u679a\u4e3e\u7c7b ...", (Object)EmbedParam.class.getSimpleName(), (Object)IEmbedParam.class.getSimpleName());
        ClassUtil.scanPackageByAnnotation((String)"com.kdgcsoft", EmbedParam.class).forEach(cls -> {
            if (IEmbedParam.class.isAssignableFrom((Class<?>)cls) && cls.isEnum()) {
                EmbedParam ann = cls.getAnnotation(EmbedParam.class);
                String group = ann.group();
                for (Object a : cls.getEnumConstants()) {
                    IEmbedParam i = (IEmbedParam)a;
                    Enum e = (Enum)a;
                    if (this.existParam(e.name())) {
                        throw new ModuleException(StrUtil.format((CharSequence)"\u53c2\u6570\u7f16\u7801\u91cd\u590d:\u7f16\u7801[{}],\u7c7b\u540d[{}]", (Object[])new Object[]{e.name(), ann.getClass().getName()}));
                    }
                    ModuleParam mParam = new ModuleParam();
                    mParam.setCode(e.name());
                    mParam.setName(i.title());
                    mParam.setType(i.type());
                    mParam.setGroup(group);
                    mParam.setDefaultValue(i.defValue());
                    mParam.setAnonAccess(i.anonAccess());
                    mParam.setOptions(i.options());
                    mParam.setDescription(i.description());
                    this.paramsList.add(mParam);
                    log.debug("\u52a0\u8f7d\u5185\u7f6e\u53c2\u6570[code='{}',name='{}'] \u4ece {}", new Object[]{mParam.getCode(), mParam.getName(), cls.getName()});
                }
            }
        });
        log.info("\u5171\u626b\u63cf\u5230:{}\u4e2a\u5185\u7f6e\u53c2\u6570.", (Object)this.paramsList.size());
    }

    private void loadEmbedMenus() {
        log.debug("\u5f00\u59cb\u626b\u63cf\u5185\u7f6e\u53c2\u6570:\u626b\u63cf\u4f7f\u7528@{}\u6ce8\u89e3\u5e76\u5b9e\u73b0\u4e86{}\u63a5\u53e3\u7684\u679a\u4e3e\u7c7b ...", (Object)EmbedMenu.class.getSimpleName(), (Object)IEmbedMenu.class.getSimpleName());
        ClassUtil.scanPackageByAnnotation((String)"com.kdgcsoft", EmbedMenu.class).forEach(cls -> {
            if (IEmbedMenu.class.isAssignableFrom((Class<?>)cls) && cls.isEnum()) {
                EmbedMenu ann = cls.getAnnotation(EmbedMenu.class);
                for (Object a : cls.getEnumConstants()) {
                    IEmbedMenu i = (IEmbedMenu)a;
                    if (this.existMenu(i.menuCode())) {
                        throw new ModuleException(StrUtil.format((CharSequence)"\u83dc\u5355\u7f16\u7801\u91cd\u590d:\u7f16\u7801[{}],\u7c7b\u540d[{}]", (Object[])new Object[]{i.menuCode(), ann.getClass().getName()}));
                    }
                    Enum e = (Enum)a;
                    ModuleMenu mMenu = new ModuleMenu();
                    mMenu.setCode(i.menuCode());
                    mMenu.setPCode(i.menuPCode());
                    mMenu.setName(i.menuName());
                    mMenu.setPath(i.menuPath());
                    mMenu.setOrder(i.orderNo());
                    this.menuList.add(mMenu);
                    log.debug("\u52a0\u8f7d\u5185\u7f6e\u53c2\u6570[code='{}',name='{}'] \u4ece {}", new Object[]{mMenu.getCode(), mMenu.getName(), cls.getName()});
                }
            }
        });
        log.info("\u5171\u626b\u63cf\u5230:{}\u4e2a\u5185\u7f6e\u83dc\u5355.", (Object)this.menuList.size());
    }

    private void syncEmbedParams() {
        log.debug("\u5f00\u59cb\u540c\u6b65\u5185\u7f6e\u53c2\u6570...");
        this.timer.restart();
        List allDbParams = this.baseModuleService.listBaseParam();
        ArrayList saveParamList = new ArrayList();
        this.paramsList.forEach(p -> {
            BaseParam dbParam = (BaseParam)CollUtil.findOne((Iterable)allDbParams, dbp -> dbp.getParamCode().equalsIgnoreCase(p.getCode()));
            if (dbParam == null) {
                dbParam = new BaseParam();
                dbParam.setParamGroup(p.getGroup());
                dbParam.setParamName(p.getName());
                dbParam.setParamCode(p.getCode().toUpperCase());
                dbParam.setEmbed(Integer.valueOf(1));
                dbParam.setAnonAccess(Integer.valueOf(YesNo.ofBoolean((boolean)p.isAnonAccess())));
                dbParam.setParamType(p.getType());
                dbParam.setDefaultValue(p.getDefaultValue());
                dbParam.setParamValue(p.getDefaultValue());
                dbParam.setParamOptions(p.getOptions());
                dbParam.setRmk(p.getDescription());
                saveParamList.add(dbParam);
            } else if (!p.sameToDb(dbParam)) {
                if (StrUtil.equals((CharSequence)dbParam.getDefaultValue(), (CharSequence)dbParam.getParamValue())) {
                    dbParam.setParamValue(p.getDefaultValue());
                }
                dbParam.setParamName(p.getName());
                dbParam.setParamType(p.getType());
                dbParam.setParamGroup(p.getGroup());
                dbParam.setAnonAccess(Integer.valueOf(YesNo.ofBoolean((boolean)p.isAnonAccess())));
                dbParam.setParamOptions(p.getOptions());
                dbParam.setDefaultValue(p.getDefaultValue());
                dbParam.setRmk(p.getDescription());
                saveParamList.add(dbParam);
            }
        });
        if (saveParamList.size() > 0) {
            this.baseModuleService.saveOrUpdateBaseParams(saveParamList);
        }
        log.info("\u5185\u7f6e\u53c2\u6570\u540c\u6b65\u5b8c\u6210,\u5171\u540c\u6b65{}\u4e2a\u5185\u7f6e\u53c2\u6570.\u8017\u65f6:{}", (Object)saveParamList.size(), (Object)this.timer.intervalPretty());
    }

    private void syncEmbedDic() {
        log.info("\u5f00\u59cb\u540c\u6b65\u5185\u7f6e\u5b57\u5178...");
        this.timer.restart();
        List dbDics = this.baseModuleService.listBaseDic();
        List dbDicItems = this.baseModuleService.listBaseDicItem();
        ArrayList saveDicList = new ArrayList();
        ArrayList saveDicItemList = new ArrayList();
        this.dicList.forEach(d -> {
            BaseDict dbDic = (BaseDict)CollUtil.findOne((Iterable)dbDics, dic -> dic.getDictCode().equals(d.getCode()));
            if (dbDic == null) {
                dbDic = new BaseDict();
                dbDic.setDictCode(d.getCode());
                dbDic.setDictName(d.getName());
                dbDic.setEmbed(Integer.valueOf(1));
                dbDic.setDictType(DicType.LIST);
                dbDic.setRmk(d.getDescription());
                saveDicList.add(dbDic);
            }
            CollUtil.forEach(d.getOptions(), (CollUtil.Consumer & Serializable)(o, index) -> {
                BaseDictItem dbDicItem = (BaseDictItem)CollUtil.findOne((Iterable)dbDicItems, i -> i.getDictCode().equals(d.getCode()) && i.getValue().equals(o.getKey()));
                if (dbDicItem == null) {
                    dbDicItem = new BaseDictItem();
                    dbDicItem.setDictItemPid(ComConst.DEF_TREE_ROOT_ID);
                    dbDicItem.setEmbed(Integer.valueOf(1));
                    dbDicItem.setDictCode(d.getCode());
                    dbDicItem.setValue((String)o.getKey());
                    dbDicItem.setText((String)o.getValue());
                    dbDicItem.setOrdNo(Integer.valueOf(index));
                    saveDicItemList.add(dbDicItem);
                }
            });
        });
        if (saveDicList.size() > 0) {
            this.baseModuleService.saveOrUpdateBaseDic(saveDicList);
            dbDics.addAll(saveDicList);
        }
        if (saveDicItemList.size() > 0) {
            this.baseModuleService.saveOrUpdateBaseDicItem(saveDicItemList);
            saveDicItemList.forEach(dicItem -> {
                BaseDict dict = (BaseDict)CollUtil.findOne((Iterable)dbDics, dic -> dic.getDictCode().equals(dicItem.getDictCode()));
                if (dict != null) {
                    dicItem.setDictId(dict.getDictId());
                }
            });
            this.baseModuleService.saveOrUpdateBaseDicItem(saveDicItemList);
        }
        log.info("\u5185\u7f6e\u5b57\u5178\u540c\u6b65\u5b8c\u6210,\u5171\u540c\u6b65{}\u4e2a\u5185\u7f6e\u5b57\u5178,{}\u4e2a\u5185\u7f6e\u5b57\u5178\u9879.\u8017\u65f6:{}", new Object[]{saveDicList.size(), saveDicItemList.size(), this.timer.intervalPretty()});
    }

    private void syncEmbedMenus() {
        log.info("\u5f00\u59cb\u540c\u6b65\u5185\u7f6e\u83dc\u5355...");
        this.timer.restart();
        List dbMenuList = this.baseModuleService.listBaseMenu();
        ArrayList saveMenuList = new ArrayList();
        this.menuList.forEach(menu -> {
            BaseMenu one = (BaseMenu)CollUtil.findOne((Iterable)dbMenuList, dbMenu -> dbMenu.getMenuCode().equals(menu.getCode()));
            if (one == null) {
                one = new BaseMenu();
                one.setMenuCode(menu.getCode());
                one.setPcode(menu.getPCode());
                one.setMenuName(menu.getName());
                one.setUrl(menu.getPath());
                one.setIcon(menu.getIcon());
                one.setEmbed(Integer.valueOf(1));
                one.setEnabled(Integer.valueOf(1));
                one.setOpenType(MenuOpenType.TAB);
                one.setOrdNo(menu.getOrder());
                saveMenuList.add(one);
            }
        });
        if (saveMenuList.size() > 0) {
            this.baseModuleService.saveOrUpdateBaseMenu(saveMenuList);
            dbMenuList.addAll(saveMenuList);
            saveMenuList.forEach(entity -> {
                BaseMenu one = (BaseMenu)CollUtil.findOne((Iterable)dbMenuList, dbMenu -> dbMenu.getMenuCode().equals(entity.getPcode()));
                if (one != null) {
                    entity.setMenuPid(one.getMenuId());
                }
            });
            this.baseModuleService.saveOrUpdateBaseMenu(saveMenuList);
        }
        log.info("\u5185\u7f6e\u83dc\u5355\u540c\u6b65\u5b8c\u6210,\u5171\u540c\u6b65{}\u4e2a\u5185\u7f6e\u83dc\u5355.\u8017\u65f6:{}", (Object)saveMenuList.size(), (Object)this.timer.intervalPretty());
    }

    public void refreshParamsMap() {
        log.info("\u4ece\u6570\u636e\u5e93\u52a0\u8f7d\u6240\u6709\u53c2\u6570....");
        this.timer.restart();
        this.paramsMap.clear();
        List dbParams = this.baseModuleService.listBaseParam();
        dbParams.forEach(baseParam -> this.paramsMap.put(baseParam.getParamCode(), (BaseParam)baseParam));
        log.info("\u7cfb\u7edf\u53c2\u6570\u52a0\u8f7d\u5b8c\u6210,\u5171\u52a0\u8f7d{}\u4e2a\u7cfb\u7edf\u53c2\u6570(\u5305\u542b\u5185\u7f6e\u53c2\u6570).\u8017\u65f6:{}", (Object)this.paramsMap.size(), (Object)this.timer.intervalPretty());
    }

    private boolean existMenu(String code) {
        return CollUtil.findOne(this.menuList, param -> param.getCode().equals(code)) != null;
    }

    private boolean existParam(String code) {
        return CollUtil.findOne(this.paramsList, param -> param.getCode().equals(code)) != null;
    }

    private boolean existDic(String code) {
        return CollUtil.findOne(this.dicList, dic -> dic.getCode().equals(code)) != null;
    }

    public Map<String, Object> getAnonParamsValueMap() {
        HashMap map = MapUtil.newHashMap();
        for (String key : this.paramsMap.keySet()) {
            BaseParam param = this.paramsMap.get(key);
            if (param.getAnonAccess() != 1) continue;
            map.put(key, param.getParamValue());
        }
        return map;
    }

    public Map<String, Object> getAnonParamsFmtValueMap() {
        HashMap map = MapUtil.newHashMap();
        for (String key : this.paramsMap.keySet()) {
            BaseParam param = this.paramsMap.get(key);
            if (param.getAnonAccess() != 1) continue;
            map.put(key, param.getParamValue());
        }
        return map;
    }

    public String getParamValue(String key) {
        if (this.paramsMap.containsKey(key)) {
            return this.paramsMap.get(key).getParamValue();
        }
        return null;
    }

    public Object getBaseParamFmtValue(String key) {
        if (this.paramsMap.containsKey(key)) {
            return this.paramsMap.get(key).getFmtValue();
        }
        return null;
    }
}

