/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.openguass;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.util.Properties;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.Plugin;
import org.flywaydb.core.internal.authentication.postgres.PgpassFileReader;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLDatabase;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLParser;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeMessage;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Plugin.class})
public class OpenGuassDatabaseType
extends BaseDatabaseType {
    private static final Logger log = LoggerFactory.getLogger(OpenGuassDatabaseType.class);

    public String getName() {
        return "PostgreSQL";
    }

    public int getNullType() {
        return 0;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:opengauss:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        return "org.opengauss.Driver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("PostgreSQL");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new PostgreSQLDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new PostgreSQLParser(configuration, parsingContext);
    }

    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        props.put("applicationName", "Flyway by Redgate");
    }

    public boolean detectUserRequiredByUrl(String url) {
        return !url.contains("user=");
    }

    public boolean detectPasswordRequiredByUrl(String url) {
        return !url.contains("password=");
    }

    public boolean externalAuthPropertiesRequired(String url, String username, String password) {
        return super.externalAuthPropertiesRequired(url, username, password);
    }

    public Properties getExternalAuthProperties(String url, String username) {
        PgpassFileReader pgpassFileReader = new PgpassFileReader();
        if (pgpassFileReader.getPgpassFilePath() != null) {
            log.info(FlywayTeamsUpgradeMessage.generate((String)("pgpass file '" + pgpassFileReader.getPgpassFilePath() + "'"), (String)"use this for database authentication"));
        }
        return super.getExternalAuthProperties(url, username);
    }
}

