/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.jdbc.reader.metadata;

import cn.hutool.core.util.StrUtil;
import cn.hutool.db.meta.Table;
import com.kdgcsoft.plugin.collect.jdbc.reader.AbstractMetadataService;
import com.kdgcsoft.plugin.common.resource.db.AbstractDBResourcePlugin;
import com.kdgcsoft.plugin.common.util.DbMetaUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDEngineMetadata
extends AbstractMetadataService {
    private static final Logger log = LoggerFactory.getLogger(TDEngineMetadata.class);

    public TDEngineMetadata(AbstractDBResourcePlugin resourcePlugin) throws Exception {
        super(resourcePlugin);
    }

    private void getTables(List<String> tables, Connection conn, String catalog, boolean isSuperTable) throws Exception {
        String sql = "show " + catalog + (isSuperTable ? ".stables " : ".tables ");
        try (PreparedStatement pstmt = conn.prepareStatement(sql);
             ResultSet rs = pstmt.executeQuery();){
            while (rs.next()) {
                String tableName = rs.getString(isSuperTable ? "name" : "table_name");
                if (!StrUtil.isNotBlank((CharSequence)tableName)) continue;
                tables.add(tableName);
            }
        }
    }

    @Override
    public List<String> getCatalogs() throws Exception {
        ArrayList<String> catalogs = new ArrayList<String>();
        String sql = "show databases";
        try (Statement st = this.conn.createStatement();){
            ResultSet rs = st.executeQuery(sql);
            while (rs.next()) {
                String name = rs.getString("name");
                if ("log".equals(name)) continue;
                catalogs.add(name);
            }
        }
        return catalogs;
    }

    @Override
    public List<String> getSchemas(String catalog) throws Exception {
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add(catalog);
        return schemas;
    }

    @Override
    public Iterator<Table> getTables(String catalog, String schema, String[] tableTypes) throws Exception {
        ArrayList<String> tables = new ArrayList<String>();
        this.getTables(tables, this.conn, schema, true);
        this.getTables(tables, this.conn, schema, false);
        ArrayList<Table> list = new ArrayList<Table>();
        for (String table : tables) {
            list.add(DbMetaUtil.getTableMeta4TD((Connection)this.conn, (String)catalog, (String)schema, (String)table));
        }
        return list.iterator();
    }
}

