/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.jdbc.reader.metadata;

import cn.hutool.db.meta.Table;
import com.kdgcsoft.plugin.collect.jdbc.reader.AbstractMetadataService;
import com.kdgcsoft.plugin.common.resource.db.AbstractDBResourcePlugin;
import com.kdgcsoft.plugin.common.util.DbMetaUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class SqlServerMetadata
extends AbstractMetadataService {
    private static final String DRIVERCLASS = "com.microsoft.sqlserver.jdbc.SQLServerDriver";

    public SqlServerMetadata(AbstractDBResourcePlugin resourcePlugin) throws Exception {
        super(resourcePlugin);
    }

    @Override
    public List<String> getCatalogs() throws Exception {
        ArrayList<String> catalogs = new ArrayList<String>();
        ArrayList<String> system_catalog = new ArrayList<String>(Arrays.asList("master", "model", "msdb", "tempdb"));
        try (ResultSet rs = this.dbMetaData.getCatalogs();){
            while (rs.next()) {
                String catalog = rs.getString(1);
                if (system_catalog.contains(catalog)) continue;
                catalogs.add(catalog);
            }
        }
        return catalogs;
    }

    @Override
    public List<String> getSchemas(String catalog) throws Exception {
        ArrayList<String> schemas = new ArrayList<String>();
        ArrayList<String> system_schema = new ArrayList<String>(Arrays.asList("db_accessadmin", "db_backupoperator", "db_datareader", "db_datawriter", "db_ddladmin", "db_denydatareader", "db_denydatawriter", "db_owner", "db_securityadmin", "INFORMATION_SCHEMA", "sys"));
        try (ResultSet rs = this.dbMetaData.getSchemas(catalog, null);){
            while (rs.next()) {
                String schema = rs.getString("TABLE_SCHEM");
                if (system_schema.contains(schema)) continue;
                schemas.add(schema);
            }
        }
        if (schemas.size() == 0) {
            schemas.add(catalog);
        }
        return schemas;
    }

    @Override
    public Iterator<Table> getTables(String catalog, String schema, String[] tableTypes) throws Exception {
        ArrayList<Table> tables = new ArrayList<Table>();
        Connection connection = this.changeConnection(catalog);
        DatabaseMetaData dbMetadata = connection.getMetaData();
        try (ResultSet rs = dbMetadata.getTables(catalog, schema, null, tableTypes);){
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                String remark = rs.getString("REMARKS");
                Table table = DbMetaUtil.getTableMeta((Connection)this.conn, (String)catalog, (String)schema, (String)name, (String)remark);
                tables.add(table);
            }
        }
        return tables.iterator();
    }

    private Connection changeConnection(String catalog) throws Exception {
        Class.forName(DRIVERCLASS);
        String connString = this.connectionString.substring(0, this.connectionString.lastIndexOf("/") + 1) + catalog;
        return DriverManager.getConnection(connString, this.username, this.password);
    }
}

