/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.jdbc.reader.metadata;

import cn.hutool.db.meta.Table;
import com.kdgcsoft.plugin.collect.jdbc.reader.AbstractMetadataService;
import com.kdgcsoft.plugin.common.resource.db.AbstractDBResourcePlugin;
import com.kdgcsoft.plugin.common.util.DbMetaUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlMetadata
extends AbstractMetadataService {
    private static final Logger log = LoggerFactory.getLogger(PostgresqlMetadata.class);
    private static final String DRIVERCLASS = "org.postgresql.Driver";

    public PostgresqlMetadata(AbstractDBResourcePlugin resourcePlugin) throws Exception {
        super(resourcePlugin);
    }

    @Override
    public List<String> getCatalogs() throws Exception {
        ArrayList<String> catalogs = new ArrayList<String>();
        String sql = "select datname from pg_database where datistemplate=false";
        try (Statement st = this.conn.createStatement();){
            ResultSet rs = st.executeQuery(sql);
            while (rs.next()) {
                catalogs.add(rs.getString("datname"));
            }
        }
        catch (Exception e) {
            log.error("[Exception getSchema Exception] --> the exception message is:{}", (Object)e.getMessage(), (Object)e);
        }
        return catalogs;
    }

    @Override
    public List<String> getSchemas(String catalog) throws Exception {
        ArrayList<String> schemas = new ArrayList<String>();
        Connection connection = this.changeConnection(catalog);
        DatabaseMetaData dbMetadata = connection.getMetaData();
        ArrayList<String> system_schemas = new ArrayList<String>(Arrays.asList("information_schema", "pg_catalog"));
        try (ResultSet rs = dbMetadata.getSchemas(catalog, null);){
            while (rs.next()) {
                if (system_schemas.contains(rs.getString(1))) continue;
                schemas.add(rs.getString(1));
            }
        }
        return schemas;
    }

    @Override
    public Iterator<Table> getTables(String catalog, String schema, String[] tableTypes) throws Exception {
        ArrayList<Table> tables = new ArrayList<Table>();
        Connection connection = this.changeConnection(catalog);
        DatabaseMetaData dbMetadata = connection.getMetaData();
        try (ResultSet rs = dbMetadata.getTables(catalog, schema, null, tableTypes);){
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String tableRemark = rs.getString("REMARKS");
                Table table = DbMetaUtil.getTableMeta((Connection)connection, (String)catalog, (String)schema, (String)tableName, (String)tableRemark);
                tables.add(table);
            }
        }
        return tables.iterator();
    }

    private Connection changeConnection(String catalog) throws Exception {
        Class.forName(DRIVERCLASS);
        String connString = this.connectionString.substring(0, this.connectionString.lastIndexOf("/") + 1) + catalog;
        return DriverManager.getConnection(connString, this.username, this.password);
    }
}

