/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.jdbc.reader.metadata;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.Table;
import com.kdgcsoft.plugin.collect.jdbc.reader.AbstractMetadataService;
import com.kdgcsoft.plugin.common.resource.db.AbstractDBResourcePlugin;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetadata
extends AbstractMetadataService {
    private static final Logger log = LoggerFactory.getLogger(HiveMetadata.class);

    public HiveMetadata(AbstractDBResourcePlugin resourcePlugin) throws Exception {
        super(resourcePlugin);
    }

    @Override
    public List<String> getCatalogs() throws Exception {
        ArrayList<String> catalogs = new ArrayList<String>();
        catalogs.add(this.resourcePlugin.getParam().getCatalog());
        return catalogs;
    }

    @Override
    public List<String> getSchemas(String catalog) throws Exception {
        ArrayList<String> schemas = new ArrayList<String>();
        String sql = "show databases";
        try (Statement st = this.conn.createStatement();){
            ResultSet rs = st.executeQuery(sql);
            while (rs.next()) {
                schemas.add(rs.getString("database_name"));
            }
        }
        return schemas;
    }

    @Override
    public Iterator<Table> getTables(String catalog, String schema, String[] tableTypes) throws Exception {
        ArrayList<Table> tables = new ArrayList<Table>();
        String updateSql = "use " + schema;
        try (PreparedStatement stmt = this.conn.prepareStatement(updateSql);){
            stmt.executeUpdate();
            String sql = "show tables";
            try (Statement st = this.conn.createStatement();){
                ResultSet rs = st.executeQuery(sql);
                while (rs.next()) {
                    String tableName = rs.getString("tab_name");
                    try {
                        Table table = this.getTableMeta(catalog, schema, tableName);
                        tables.add(table);
                    }
                    catch (Exception e) {
                        log.error("[Exception getTable Exception] --> the exception message is:{}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("[Exception getTable Exception] --> the exception message is:{}", (Object)e.getMessage(), (Object)e);
        }
        return tables.iterator();
    }

    public Table getTableMeta(String catalog, String schema, String tableName) throws Exception {
        Table table = Table.create((String)tableName);
        try {
            table.setCatalog(catalog);
            table.setSchema(schema);
            String sql = "describe extended " + schema + "." + tableName;
            try (Statement st = this.conn.createStatement();){
                ResultSet rs = st.executeQuery(sql);
                while (rs.next()) {
                    if (!ObjectUtil.isNotEmpty((Object)rs.getString("col_name")) || !ObjectUtil.isNotEmpty((Object)rs.getString("data_type"))) continue;
                    if (rs.getString("col_name").equals("Detailed Table Information")) {
                        table.setComment(this.getTableComment(String.valueOf(rs.getString("data_type"))));
                        continue;
                    }
                    Column column = new Column();
                    column.setName(String.valueOf(rs.getString("col_name")));
                    column.setTypeName(String.valueOf(rs.getString("data_type")));
                    column.setComment(String.valueOf(rs.getString("comment")));
                    table.setColumn(column);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DbRuntimeException("Get columns error!", new Object[]{e.getMessage(), e});
        }
        return table;
    }

    private String getTableComment(String tableInfo) {
        if (null == tableInfo || tableInfo.trim().length() == 0) {
            return null;
        }
        String commentPrefix = "comment=";
        if (!(tableInfo = tableInfo.trim()).contains(commentPrefix)) {
            return null;
        }
        int startIndex = tableInfo.indexOf(commentPrefix);
        int endIndex = tableInfo.indexOf(", ", startIndex);
        int beginIndex = startIndex + commentPrefix.length();
        String comment = endIndex < 0 ? tableInfo.substring(beginIndex) : tableInfo.substring(beginIndex, endIndex);
        return comment;
    }
}

