/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.jdbc.reader;

import com.kdgcsoft.common.exception.BizException;
import com.kdgcsoft.plugin.collect.jdbc.reader.AbstractMetadataService;
import com.kdgcsoft.plugin.collect.jdbc.reader.metadata.DB2Metadata;
import com.kdgcsoft.plugin.collect.jdbc.reader.metadata.HiveMetadata;
import com.kdgcsoft.plugin.collect.jdbc.reader.metadata.MysqlMetadata;
import com.kdgcsoft.plugin.collect.jdbc.reader.metadata.OracleMetadata;
import com.kdgcsoft.plugin.collect.jdbc.reader.metadata.PostgresqlMetadata;
import com.kdgcsoft.plugin.collect.jdbc.reader.metadata.SqlServerMetadata;
import com.kdgcsoft.plugin.collect.jdbc.reader.metadata.TDEngineMetadata;
import com.kdgcsoft.plugin.common.resource.db.AbstractDBResourcePlugin;
import java.sql.Connection;

public class MetadataServiceFactory {
    public static AbstractMetadataService get(AbstractDBResourcePlugin resourcePlugin, Connection connection) throws Exception {
        switch (resourcePlugin.getJdbcDBType(connection)) {
            case POSTGRESQL: {
                return new PostgresqlMetadata(resourcePlugin);
            }
            case MySQL: {
                return new MysqlMetadata(resourcePlugin);
            }
            case ORACLE: {
                return new OracleMetadata(resourcePlugin);
            }
            case SQLSERVER: {
                return new SqlServerMetadata(resourcePlugin);
            }
            case DB2: {
                return new DB2Metadata(resourcePlugin);
            }
            case HIVE: {
                return new HiveMetadata(resourcePlugin);
            }
            case TDENGINE: {
                return new TDEngineMetadata(resourcePlugin);
            }
        }
        throw new BizException("\u4e0d\u53ef\u7528\u63d2\u4ef6\u7c7b\u578b");
    }
}

