/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.jdbc.reader;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.Table;
import com.kdgcsoft.plugin.api.DataNumEstimateType;
import com.kdgcsoft.plugin.api.PluginContext;
import com.kdgcsoft.plugin.api.PluginType;
import com.kdgcsoft.plugin.api.param.PluginParam;
import com.kdgcsoft.plugin.api.record.Item;
import com.kdgcsoft.plugin.api.record.ItemType;
import com.kdgcsoft.plugin.api.record.Record;
import com.kdgcsoft.plugin.collect.jdbc.reader.AbstractMetadataService;
import com.kdgcsoft.plugin.collect.jdbc.reader.DSMetadataReaderPluginParam;
import com.kdgcsoft.plugin.collect.jdbc.reader.MetadataServiceFactory;
import com.kdgcsoft.plugin.collect.jdbc.reader.TableType;
import com.kdgcsoft.plugin.common.AbstractDataReadPlugin;
import com.kdgcsoft.plugin.common.model.OutputField;
import com.kdgcsoft.plugin.common.resource.db.AbstractDBResourcePlugin;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;

public class DSMetadataReaderPlugin
extends Plugin {
    public DSMetadataReaderPlugin(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Extension
    public static class DSMetadataIDataReadPlugin
    extends AbstractDataReadPlugin
    implements ExtensionPoint {
        private AbstractDBResourcePlugin resourcePlugin;
        private boolean collectAllDB;
        private String[] tableTypes;
        private List<Record> records;
        private List<Iterator<Table>> tables;
        private Iterator<Table> it;
        private AbstractMetadataService metadataService;
        private List<OutputField> columns;

        public void initRead(PluginContext context, PluginParam param) throws Exception {
            DSMetadataReaderPluginParam pluginParam = (DSMetadataReaderPluginParam)param;
            this.resourcePlugin = (AbstractDBResourcePlugin)context.resourcePlugin(pluginParam.getResourceCode());
            this.collectAllDB = pluginParam.isCollectAllDB();
            this.columns = pluginParam.getColumns();
            List<TableType> collectTableTypes = pluginParam.getCollectTableTypes();
            this.tableTypes = CollUtil.isNotEmpty(collectTableTypes) ? (String[])collectTableTypes.stream().map(TableType::getValue).toArray(String[]::new) : (String[])Arrays.stream(TableType.values()).map(TableType::getValue).toArray(String[]::new);
            try (Connection connection = this.resourcePlugin.openConnection();){
                this.metadataService = MetadataServiceFactory.get(this.resourcePlugin, connection);
            }
            this.it = null;
            this.tables = new ArrayList<Iterator<Table>>();
            this.records = new ArrayList<Record>();
        }

        public void begin() throws Exception {
            List<Object> catalogs = new ArrayList<String>();
            if (this.collectAllDB) {
                catalogs = this.metadataService.getCatalogs();
            } else {
                catalogs.add(this.resourcePlugin.getDb());
            }
            CountDownLatch catalogLatch = new CountDownLatch(catalogs.size());
            for (String string : catalogs) {
                ExecutorService catalogExecutor = Executors.newFixedThreadPool(10, r -> new Thread(r, "CatalogSyncThread"));
                CompletableFuture.runAsync(() -> {
                    try {
                        List<String> schemas = this.metadataService.getSchemas(catalog);
                        CountDownLatch schemaLatch = new CountDownLatch(schemas.size());
                        for (String schema : schemas) {
                            ExecutorService schemaExecutor = Executors.newFixedThreadPool(10, r -> new Thread(r, "SchemaSyncThread"));
                            CompletableFuture.runAsync(() -> {
                                try {
                                    Iterator<Table> list = this.metadataService.getTables(catalog, schema, this.tableTypes);
                                    this.tables.add(list);
                                }
                                catch (Exception e) {
                                    this.mb.writeExceptionLog(e);
                                }
                                finally {
                                    schemaLatch.countDown();
                                }
                            }, schemaExecutor);
                        }
                        try {
                            schemaLatch.await(1L, TimeUnit.HOURS);
                        }
                        catch (Exception e) {
                            this.mb.writeExceptionLog(e);
                        }
                    }
                    catch (Exception e) {
                        this.mb.writeExceptionLog(e);
                    }
                    finally {
                        catalogLatch.countDown();
                    }
                }, catalogExecutor);
            }
            try {
                catalogLatch.await(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                this.mb.writeExceptionLog((Exception)e);
            }
            this.nextIterator();
        }

        private void nextIterator() {
            if (this.tables.size() > 0) {
                this.it = this.tables.remove(0);
            }
        }

        private void buildTableRecords() {
            Table table = this.it.next();
            for (Column column : table.getColumns()) {
                Record record = new Record();
                this.columns.forEach(i -> {
                    switch (i.getSrcColumnName()) {
                        case "catalog": {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)table.getCatalog())));
                            break;
                        }
                        case "schema": {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)table.getSchema())));
                            break;
                        }
                        case "tableName": {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)table.getTableName())));
                            break;
                        }
                        case "tableRemark": {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)table.getComment())));
                            break;
                        }
                        case "columnName": {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)column.getName())));
                            break;
                        }
                        case "columnType": {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)column.getTypeName())));
                            break;
                        }
                        case "columnSize": {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)String.valueOf(column.getSize()))));
                            break;
                        }
                        case "columnScale": {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)String.valueOf(column.getDigit()))));
                            break;
                        }
                        case "nullable": {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)(column.isNullable() ? "true" : "false"))));
                            break;
                        }
                        case "columnRemark": {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)column.getComment())));
                            break;
                        }
                        case "autoIncrement": {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)(column.isAutoIncrement() ? "true" : "false"))));
                            break;
                        }
                        case "pk": {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)(column.isPk() ? "true" : "false"))));
                            break;
                        }
                        default: {
                            record.add(new Item(i.getDstColumnName(), ItemType.STRING, (Serializable)((Object)String.valueOf(i.getDefaultValue()))));
                        }
                    }
                });
                this.records.add(record);
            }
            this.totalDataNum += (long)this.records.size();
        }

        public boolean hasNext() throws Exception {
            return this.tables.size() > 0 || this.records.size() > 0 || this.it != null && this.it.hasNext();
        }

        public long estimateDataNum() {
            return this.totalDataNum;
        }

        public DataNumEstimateType estimateType() {
            return DataNumEstimateType.DYNAMIC_NUM;
        }

        public Record nextRecord() throws Exception {
            if (this.records.size() > 0) {
                return this.records.remove(0);
            }
            if (this.it.hasNext()) {
                this.buildTableRecords();
            } else {
                this.nextIterator();
            }
            return null;
        }

        public void end() throws Exception {
        }

        public PluginType type() {
            return PluginType.READER;
        }

        public Class<? extends PluginParam> pluginParamClass() {
            return DSMetadataReaderPluginParam.class;
        }

        public String configComponent() {
            return "DSMetadataReaderConfigForm";
        }
    }
}

