/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.jdbc.reader;

import cn.hutool.db.meta.Table;
import com.kdgcsoft.plugin.common.resource.db.AbstractDBResourcePlugin;
import com.kdgcsoft.plugin.common.util.DbMetaUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractMetadataService {
    public Connection conn;
    public final DatabaseMetaData dbMetaData;
    public AbstractDBResourcePlugin resourcePlugin;
    public String connectionString;
    public String username;
    public String password;

    public AbstractMetadataService(AbstractDBResourcePlugin resourcePlugin) throws Exception {
        this.resourcePlugin = resourcePlugin;
        this.conn = resourcePlugin.openConnection();
        this.dbMetaData = this.conn.getMetaData();
        this.connectionString = resourcePlugin.getConnectionString();
        this.username = resourcePlugin.getUsername();
        this.password = resourcePlugin.getPassword();
    }

    public List<String> getCatalogs() throws Exception {
        ArrayList<String> catalogs = new ArrayList<String>();
        try (ResultSet rs = this.dbMetaData.getCatalogs();){
            while (rs.next()) {
                catalogs.add(rs.getString(1));
            }
        }
        return catalogs;
    }

    public List<String> getSchemas(String catalog) throws Exception {
        ArrayList<String> schemas = new ArrayList<String>();
        try (ResultSet rs = this.dbMetaData.getSchemas(catalog, null);){
            while (rs.next()) {
                schemas.add(rs.getString("TABLE_SCHEM"));
            }
        }
        if (schemas.size() == 0) {
            schemas.add(catalog);
        }
        return schemas;
    }

    public Iterator<Table> getTables(String catalog, String schema, String[] tableTypes) throws Exception {
        return this.getTables(catalog, schema, null, tableTypes);
    }

    public Iterator<Table> getTables(String catalog, String schema, String tableName, String[] tableTypes) throws Exception {
        ArrayList<Table> tables = new ArrayList<Table>();
        try (ResultSet rs = this.dbMetaData.getTables(catalog, schema, tableName, tableTypes);){
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                String remark = rs.getString("REMARKS");
                Table table = DbMetaUtil.getTableMeta((Connection)this.conn, (String)catalog, (String)schema, (String)name, (String)remark);
                tables.add(table);
            }
        }
        return tables.iterator();
    }
}

