/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.usiflow.webframe.web.service.flow;

import com.kdgc.framework.dao.jpa.IBaseDao;
import com.kdgc.framework.service.jpa.impl.BaseServiceImpl;
import com.kdgc.framework.web.entity.admin.FwUser;
import com.kdgc.framework.web.service.admin.IFwUserService;
import com.kdgc.usiflow.webframe.web.dao.flow.FlowUtilDao;
import com.kdgc.usiflow.webframe.web.dao.flow.WorkItemDao;
import com.kdgc.usiflow.webframe.web.model.flow.WorkItem;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkItemService
extends BaseServiceImpl<WorkItem, Long> {
    @Autowired
    private WorkItemDao workItemDao;
    @Autowired
    private FlowUtilDao flowUtilDao;
    @Resource(name="FwUserServiceImpl")
    private IFwUserService userService;

    @Autowired
    public void setBaseDao(WorkItemDao workItemDao) {
        super.setBaseDao((IBaseDao)workItemDao);
    }

    @Transactional(readOnly=true)
    public List<WorkItem> queryWorkItem(Long activityinstid) {
        List<WorkItem> list = this.workItemDao.queryWorkItem(activityinstid);
        ArrayList<WorkItem> list1 = new ArrayList<WorkItem>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                FwUser fwUser;
                WorkItem workItem = list.get(i);
                if (StringUtils.isNumeric((String)workItem.getParticipant()) && (fwUser = (FwUser)this.userService.find((Serializable)Long.valueOf(workItem.getParticipant()))) != null) {
                    workItem.setParticipant(fwUser.getUsername());
                }
                list1.add(workItem);
            }
        }
        return list1;
    }

    @Transactional(readOnly=true)
    public List<WorkItem> queryWorkItemByDefid(Long processinstid, String activitydefid) {
        List<WorkItem> list = this.workItemDao.queryWorkItemByDefid(processinstid, activitydefid);
        ArrayList<WorkItem> list1 = new ArrayList<WorkItem>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                FwUser fwUser;
                WorkItem workItem = list.get(i);
                if (workItem.getParticipant() != null && !workItem.getParticipant().equals("") && (fwUser = (FwUser)this.userService.find((Serializable)Long.valueOf(workItem.getParticipant()))) != null) {
                    workItem.setParticipant(fwUser.getUsername());
                }
                list1.add(workItem);
            }
        }
        return list1;
    }

    public List<WorkItem> queryFlowList(String processInstId) throws IllegalAccessException, InvocationTargetException {
        List<WorkItem> list = this.workItemDao.queryWorkItem(processInstId);
        ArrayList<WorkItem> list1 = new ArrayList<WorkItem>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                WorkItem entity = new WorkItem();
                WorkItem workItem = list.get(i);
                BeanUtils.copyProperties((Object)entity, (Object)workItem);
                if (!StringUtils.isEmpty((String)workItem.getParticipant()) && StringUtils.isNumeric((String)workItem.getParticipant())) {
                    if (workItem.getCurrentstate() == 12L) {
                        FwUser fwUser = (FwUser)this.userService.find((Serializable)Long.valueOf(workItem.getParticipant()));
                        if (fwUser != null) {
                            entity.setParticipant(fwUser.getUsername());
                        }
                    } else {
                        String queryString = "select CASE\n                    WHEN D.PARTICTYPE = 'person' THEN\n                     (select c.username\n                        from fw_user c\n                       where c.id = d.participant)\n                    else\n                     (select wm_concat(c.username)\n                        from fw_roles u, FW_USER_ROLES ur, fw_user c\n                       where u.id = d.participant\n                         and ur.user_id = c.id\n                         and ur.role_id = u.id)\n                  end participants\n             from wf_participant d\n            where d.workitemid = ?0 ";
                        Object ob = this.flowUtilDao.getSingal(queryString, new Object[]{workItem.getWorkitemid()});
                        if (ob != null) {
                            entity.setParticipant(ob.toString());
                        }
                    }
                }
                list1.add(entity);
            }
        }
        return list1;
    }
}

