/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.usiflow.webframe.web.service.flow;

import com.kdgc.framework.modules.exception.ServiceException;
import com.kdgc.framework.web.entity.admin.FwPendingDetails;
import com.kdgc.framework.web.entity.admin.FwPendingMessage;
import com.kdgc.framework.web.entity.admin.FwUser;
import com.kdgc.framework.web.service.admin.IFwPendingMessageService;
import com.kdgc.framework.web.service.admin.IFwUserService;
import com.kdgc.usiflow.webframe.flow.AuditEnum;
import com.kdgc.usiflow.webframe.flow.ProcessEnginerHolder;
import com.kdgc.usiflow.webframe.flow.WorkItemEnum;
import com.kdgc.usiflow.webframe.web.dao.flow.FlowUtilDao;
import com.kdgc.usiflow.webframe.web.model.flow.LineCondition;
import com.kdgc.usiflow.webframe.web.model.flow.Processinst;
import com.kdgc.usiflow.webframe.web.model.flow.WfProcessDefine;
import com.kdgc.usiflow.webframe.web.service.flow.BusinessProcessService;
import com.kdgc.usiflow.webframe.web.service.flow.ProcessDefineService;
import com.kdgc.usiflow.webframe.web.service.flow.ProcessinstService;
import com.ustcsoft.usiflow.core.util.PrimaryKeyUtil;
import com.ustcsoft.usiflow.engine.core.RelaDataManagerBuilder;
import com.ustcsoft.usiflow.engine.core.data.RelaDataManager;
import com.ustcsoft.usiflow.engine.model.Participant;
import com.ustcsoft.usiflow.engine.model.ProcessInstance;
import com.ustcsoft.usiflow.engine.model.WorkItem;
import com.ustcsoft.usiflow.engine.model.elements.ActivityElement;
import com.ustcsoft.usiflow.engine.repository.IWorkItemRepository;
import com.ustcsoft.usiflow.engine.service.IProcessDefineService;
import com.ustcsoft.usiflow.engine.service.IProcessInstanceService;
import com.ustcsoft.usiflow.engine.service.IWorkItemService;
import com.ustcsoft.usiflow.engine.xml.Dom4jProcDefParser;
import com.ustcsoft.usiflow.service.spi.IParticipantService;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component(value="FlowUtilService")
@Transactional
public class FlowUtilService {
    Logger logger = Logger.getLogger(FlowUtilService.class);
    @Autowired
    private FlowUtilDao flowUtilDao;
    private IProcessInstanceService procInstService;
    private IWorkItemService workItemService;
    @Autowired
    private ProcessinstService pinstservice;
    @Autowired
    private ProcessDefineService pdefservice;
    @Autowired
    private BusinessProcessService bpservice;
    @Resource(name="FwPendingMessageServiceImpl")
    private IFwPendingMessageService fwPendingMessageService;
    @Resource(name="FwUserServiceImpl")
    private IFwUserService fwUserService;

    public Long createAndStartProcess(String name, Long userId) throws Exception {
        IProcessInstanceService procInstService = ProcessEnginerHolder.getInstance().getProcessInstanceService();
        String flowName = name.startsWith("flow.") ? name : this.getFlowName(name);
        if (!StringUtils.isEmpty((Object)flowName)) {
            ProcessInstance processinst = procInstService.createAndStartProcess(flowName, userId.toString());
            return processinst.getParentProcInstId();
        }
        this.logger.error((Object)"\u6d41\u7a0b\u521b\u5efa\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6d41\u7a0b!");
        throw new ServiceException("\u6d41\u7a0b\u521b\u5efa\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6d41\u7a0b!");
    }

    public Map<String, Object> excuteFlow(Long processInstId, Long userId, Long deptId, String msgTitle, String condition, String toActId, String TH, String advice) throws Exception {
        int status;
        HashMap<String, Object> result = new HashMap<String, Object>();
        IWorkItemService workItemService = ProcessEnginerHolder.getInstance().getWorkItemService();
        Long workitemid = this.getWorkItemId(processInstId, userId.toString());
        IWorkItemRepository workItemRep = (IWorkItemRepository)ProcessEnginerHolder.getInstance().getApplicationContext().getBean(IWorkItemRepository.class);
        WorkItem workItem = workItemRep.findWorkItem(workitemid.longValue());
        if (condition != null && !"".equals(condition)) {
            String[] acons;
            HashMap<String, Object> conditions = new HashMap<String, Object>();
            Pattern pattern = Pattern.compile("&&|\\|\\|");
            Pattern pattern2 = Pattern.compile("==|>=|<=|>|<");
            for (String acon : acons = pattern.split(condition)) {
                String[] con = pattern2.split(acon);
                con[0] = con[0].replaceAll("#", "");
                String value = con[1].trim();
                if (value.contains("'")) {
                    value = value.replaceAll("'", "");
                    conditions.put(con[0].trim(), value);
                    continue;
                }
                conditions.put(con[0].trim(), Float.valueOf(value));
            }
            this.cleanRelvant_data(processInstId, workItem.getActivityDefId());
            RelaDataManager relaDataManager = RelaDataManagerBuilder.buildRelaDataManager();
            relaDataManager.setExpressConditions(processInstId.longValue(), workItem.getActivityDefId(), conditions);
        }
        boolean isAllWorkDoned = this.isAllWorkItemIsDoneWhenPass(processInstId, workitemid);
        if ("TH".equals(TH)) {
            this.endWorkItemWhenTh(userId, processInstId, workitemid);
            status = AuditEnum.nopassed.ordinal();
        } else {
            status = "act_finish".equals(toActId) ? (isAllWorkDoned ? AuditEnum.passed.ordinal() : AuditEnum.pending.ordinal()) : AuditEnum.pending.ordinal();
        }
        workItemService.finishWorkItem(workitemid.longValue(), userId.toString(), advice, "TH".equals(TH) ? TH : "NTH", new HashMap());
        Long businessId = this.updateBusinessStatus(processInstId, status);
        this.sysMsgdealNew(businessId, userId, deptId, processInstId, toActId, workItem.getActivityDefId(), TH, isAllWorkDoned, msgTitle);
        result.put("businessId", businessId);
        result.put("isAllWorkDoned", isAllWorkDoned);
        return result;
    }

    private String excuteCondtionSql(Long processInstId, String table, String field) {
        String sql = "select " + field + " from " + table + " t where t.processinstid=?0";
        Object ob = this.flowUtilDao.getSingal(sql, new Object[]{processInstId});
        if (ob != null) {
            return String.valueOf(ob);
        }
        return null;
    }

    private boolean isFieldCondtion(String condtion) {
        Pattern pattern = Pattern.compile("^[\\w]+\\$[\\w]+$");
        Matcher matcher = pattern.matcher(condtion);
        return matcher.matches();
    }

    public static void main(String[] args) {
    }

    public List<LineCondition> getLineCondition(WorkItem workItem, Long userId, Map<String, Object> condtion) {
        Processinst processinst = (Processinst)this.pinstservice.find(Long.valueOf(workItem.getProcessInstId()));
        if (processinst == null) {
            return null;
        }
        WfProcessDefine wfprocessDefine = (WfProcessDefine)this.pdefservice.find(processinst.getProcessdefid());
        String processDefContent = wfprocessDefine.getProcessdefcontent();
        List list = Dom4jProcDefParser.parserTransitionInfo((String)processDefContent, (String)workItem.getActivityDefId());
        ArrayList<LineCondition> condtions = new ArrayList<LineCondition>(list.size());
        block0: for (Element el : list) {
            Element childel;
            LineCondition cond = new LineCondition();
            Iterator iterator = el.elementIterator("complexExpressionValue");
            while (iterator.hasNext()) {
                childel = (Element)iterator.next();
                String exp = this.isConform(workItem.getProcessInstId(), childel.getData().toString(), condtion);
                if (exp == null) continue block0;
                cond.setCondition(exp);
            }
            cond.setLineName(el.attributeValue("name"));
            cond.setToActId(el.attributeValue("to"));
            iterator = el.elementIterator("description");
            while (iterator.hasNext()) {
                childel = (Element)iterator.next();
                cond.setDescription(childel.getData().toString());
            }
            condtions.add(cond);
        }
        return condtions;
    }

    private Map<String, Object> getConditions(Long processInstId, String expression, Map<String, Object> condition) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        expression = expression.replaceAll("\\s*|\t|\r|\n", "");
        String regStr = "#([A-Za-z0-9_$]+)[==|>=|<=|>|<|!=]{1,2}([A-Za-z0-9''\\.]+)";
        Pattern pattern = Pattern.compile(regStr);
        Matcher matcher = pattern.matcher(expression);
        while (matcher.find()) {
            String leftValue = matcher.group(1);
            String rightValue = matcher.group(2);
            if (conditions.containsKey(leftValue)) continue;
            if (this.isFieldCondtion(leftValue)) {
                String[] fieldsCon = leftValue.split("\\$");
                String fieldVal = this.excuteCondtionSql(processInstId, fieldsCon[0].replaceAll("\\s*|\t|\r|\n", ""), fieldsCon[1].replaceAll("\\s*|\t|\r|\n", ""));
                if (rightValue.indexOf("'") == -1) {
                    conditions.put(leftValue, Float.valueOf(fieldVal));
                    continue;
                }
                conditions.put(leftValue, fieldVal);
                continue;
            }
            if (condition != null && condition.containsKey(leftValue)) {
                conditions.put(leftValue, condition.get(leftValue));
                continue;
            }
            if (rightValue.indexOf("'") == -1) {
                conditions.put(leftValue, Float.valueOf(rightValue));
                continue;
            }
            conditions.put(leftValue, rightValue.substring(1, rightValue.length() - 1));
        }
        String regTableStr = "#([A-Za-z0-9_]+)[\\$]{1}([A-Za-z0-9_]+)";
        Pattern tablePattern = Pattern.compile(regTableStr);
        Matcher tableMatcher = tablePattern.matcher(expression);
        while (tableMatcher.find()) {
            String leftValue = tableMatcher.group(1);
            String rightValue = tableMatcher.group(2);
            String condKey = leftValue + "$" + rightValue;
            if (conditions.containsKey(condKey)) continue;
            String fieldVal = this.excuteCondtionSql(processInstId, leftValue, rightValue);
            if (this.isNumber(fieldVal)) {
                conditions.put(condKey, Float.valueOf(fieldVal));
                continue;
            }
            conditions.put(condKey, fieldVal);
        }
        return conditions;
    }

    private String isConform(Long processInstId, String expression, Map<String, Object> condition) {
        if (com.kdgc.framework.modules.utils.StringUtils.isBlank((CharSequence)expression)) {
            return expression.trim();
        }
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("SpringExpression");
        Bindings variables = engine.createBindings();
        variables.putAll((Map<? extends String, ? extends Object>)condition);
        variables.putAll((Map<? extends String, ? extends Object>)this.getConditions(processInstId, expression, condition));
        expression = expression.replaceAll("&&", "and");
        expression = expression.replaceAll("\\|\\|", "or");
        try {
            Object result = engine.eval(expression, variables);
            if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                StringBuffer expBuf = new StringBuffer();
                for (Map.Entry entry : variables.entrySet()) {
                    expBuf.append("##");
                    expBuf.append((String)entry.getKey());
                    expBuf.append("==");
                    if (entry.getValue() instanceof String) {
                        expBuf.append("'" + entry.getValue() + "'");
                    } else {
                        expBuf.append(entry.getValue());
                    }
                    expBuf.append("&&");
                }
                int expBufLen = expBuf.length();
                if (expBufLen > 0) {
                    expBuf.delete(expBufLen - 2, expBufLen);
                }
                return expBuf.toString();
            }
            return null;
        }
        catch (ScriptException e) {
            this.logger.error((Object)("\u89e3\u6790\u8868\u8fbe\u5f0f\u5931\u8d25\uff1a" + expression));
            return null;
        }
    }

    private boolean isNumber(String s) {
        String regex = "^[1-9][0-9]*\\.[0-9]+$|^[1-9][0-9]*$|^0+\\.[0-9]+$";
        Pattern pattern = Pattern.compile(regex);
        char c = s.charAt(0);
        if (c == '+' || c == '-') {
            s = s.substring(1);
        }
        Matcher matcher = pattern.matcher(s);
        return matcher.matches();
    }

    public void sysMsgdealNew(Long businessId, Long userId, Long deptId, Long processInstId, String toActId, String ActivityDefId, String TH, boolean isAllWorkDoned, String msgTitle) throws Exception {
        IProcessDefineService proservice = ProcessEnginerHolder.getInstance().getProcessDefineService();
        ActivityElement actEle = (ActivityElement)proservice.findProcessDefine(((Processinst)this.pinstservice.find(processInstId)).getProcessdefid().longValue()).getProcessElement().getActivitys().get(toActId);
        this.fwPendingMessageService.updateMsgStatus(processInstId, userId, "TH".equals(TH) || isAllWorkDoned);
        if (!"act_finish".equals(toActId) && ("TH".equals(TH) || isAllWorkDoned)) {
            String queryModuleUrlPath = "/ProcessDefine/ProcessProperty/ExtendNodes/extendNode[@key='module_url']/@value";
            String processDefContent = this.bpservice.queryFlowContent(null, processInstId, "");
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read((Reader)new StringReader(processDefContent));
                Map properties = actEle.getProperties();
                String moduleUrl = (String)properties.get("module_url");
                ArrayList<Long> receiveIds = new ArrayList<Long>();
                if ("TH".equals(TH)) {
                    String receive = this.getLastDealPerson(processInstId, toActId);
                    receiveIds.add(Long.valueOf(receive));
                } else {
                    IWorkItemService workItemService = ProcessEnginerHolder.getInstance().getWorkItemService();
                    List workList = workItemService.findUnFinishedWorkItemByProcessInstId(processInstId.longValue());
                    String deptFilter = (String)properties.get("isFilter");
                    StringBuilder role = new StringBuilder();
                    for (WorkItem work : workList) {
                        IWorkItemRepository workItemRep = (IWorkItemRepository)ProcessEnginerHolder.getInstance().getApplicationContext().getBean(IWorkItemRepository.class);
                        List partlist = workItemRep.findWorkItemParticipants(work.getWorkItemId());
                        for (Participant p : partlist) {
                            if ("person".equals(p.getParticType())) {
                                Long uId = Long.valueOf(p.getParticipant());
                                if (deptFilter != null && Boolean.valueOf(deptFilter).booleanValue()) {
                                    FwUser user = (FwUser)this.fwUserService.find((Serializable)uId);
                                    if (user == null || !user.getOrgId().getId().equals(deptId)) continue;
                                    receiveIds.add(uId);
                                    continue;
                                }
                                receiveIds.add(uId);
                                continue;
                            }
                            if (!"role".equals(p.getParticType())) continue;
                            role.append("'" + p.getParticipant() + "',");
                        }
                    }
                    if (role.length() > 0) {
                        role.deleteCharAt(role.length() - 1);
                    }
                    if (deptFilter != null && Boolean.valueOf(deptFilter).booleanValue()) {
                        if (role.length() > 0) {
                            List<Long> ids = this.getNextStepPerson(deptId, role.toString());
                            receiveIds.addAll(ids);
                            this.redefinedParticipant(processInstId, ids);
                        }
                    } else if (role.length() > 0) {
                        receiveIds.addAll(this.getNextStepPerson(null, role.toString()));
                    }
                }
                String flowName = this.bpservice.getFlowNameByProcessInstId(processInstId);
                FwPendingMessage fwPendingMsg = new FwPendingMessage();
                String smd = "TH".equals(TH) ? "...\u5df2\u88ab\u9000\u56de" : "...\u9700\u8981\u60a8\u5ba1\u6838";
                fwPendingMsg.setMsgTitle("\u3010" + msgTitle + "\u3011" + flowName + smd);
                fwPendingMsg.setMsgUrl(moduleUrl);
                fwPendingMsg.setSendId(userId);
                fwPendingMsg.setBusinessId(businessId);
                fwPendingMsg.setProcessInstId(processInstId);
                String queryModuleUrl = document.selectSingleNode(queryModuleUrlPath).getText();
                fwPendingMsg.setDetailUrl(queryModuleUrl);
                for (Long receiveId : receiveIds) {
                    FwPendingDetails fwPendingDetail = new FwPendingDetails();
                    fwPendingDetail.setReceiverId(receiveId);
                    fwPendingMsg.addPendingDetails(fwPendingDetail);
                }
                this.fwPendingMessageService.save((Object)fwPendingMsg);
            }
            catch (DocumentException e) {
                this.logger.error((Object)"\u53d1\u9001\u6d88\u606f\u65f6\u89e3\u6790xml\u5931\u8d25\uff01");
                throw new ServiceException("\u6d41\u7a0bXML\u6587\u4ef6\u89e3\u6790\u5931\u8d25!");
            }
            catch (Exception e) {
                this.logger.error((Object)"\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff01");
                throw new ServiceException("\u53d1\u9001\u6d88\u606f\u5931\u8d25!", (Throwable)e);
            }
        }
        if (isAllWorkDoned && "act_finish".equals(toActId)) {
            String queryModuleUrlPath = "/ProcessDefine/ProcessProperty/ExtendNodes/extendNode[@key='module_url']/@value";
            String processDefContent = this.bpservice.queryFlowContent(null, processInstId, "");
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read((Reader)new StringReader(processDefContent));
                if (document.selectNodes(queryModuleUrlPath) != null && document.selectNodes(queryModuleUrlPath).size() != 0) {
                    String queryModuleUrl = document.selectSingleNode(queryModuleUrlPath).getText();
                    String tableName = this.getFlowTableName(processInstId);
                    Long createBy = this.queryCreateBy(tableName, processInstId);
                    String flowName = this.bpservice.getFlowNameByProcessInstId(processInstId);
                    FwPendingMessage fwPendingMsg = new FwPendingMessage();
                    fwPendingMsg.setMsgTitle("\u3010" + msgTitle + "\u3011" + flowName + "...\u5ba1\u6838\u7ed3\u675f");
                    fwPendingMsg.setMsgUrl(queryModuleUrl);
                    fwPendingMsg.setSendId(userId);
                    fwPendingMsg.setBusinessId(businessId);
                    fwPendingMsg.setBusiType(FwPendingMessage.MessageType.message);
                    fwPendingMsg.setProcessInstId(processInstId);
                    fwPendingMsg.setDetailUrl(queryModuleUrl);
                    FwPendingDetails fwPendingDetail = new FwPendingDetails();
                    fwPendingDetail.setReceiverId(createBy);
                    fwPendingMsg.addPendingDetails(fwPendingDetail);
                    this.fwPendingMessageService.save((Object)fwPendingMsg);
                }
            }
            catch (DocumentException e) {
                this.logger.error((Object)"\u53d1\u9001\u6d88\u606f\u65f6\u89e3\u6790xml\u5931\u8d25\uff01");
                throw new ServiceException("\u6d41\u7a0bXML\u6587\u4ef6\u89e3\u6790\u5931\u8d25!");
            }
            catch (Exception e) {
                this.logger.error((Object)"\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff01");
                throw new ServiceException("\u53d1\u9001\u6d88\u606f\u5931\u8d25!", (Throwable)e);
            }
        }
    }

    public void sysMsgdeal(Long businessId, Long userId, Long deptId, Long processInstId, String toActId, String ActivityDefId, String TH, boolean isAllWorkDoned, String msgTitle) throws Exception {
        IProcessDefineService proservice = ProcessEnginerHolder.getInstance().getProcessDefineService();
        ActivityElement actEle = (ActivityElement)proservice.findProcessDefine(((Processinst)this.pinstservice.find(processInstId)).getProcessdefid().longValue()).getProcessElement().getActivitys().get(toActId);
        this.fwPendingMessageService.updateMsgStatus(processInstId, userId, "TH".equals(TH) || isAllWorkDoned);
        if (!"act_finish".equals(toActId) && ("TH".equals(TH) || isAllWorkDoned)) {
            String moduleUrlPath = "/ProcessDefine/Activitys/Activity[@id='" + toActId + "']/ExtendNodes/extendNode[@key='" + "module_url" + "']/@value";
            String filterPath = "/ProcessDefine/Activitys/Activity[@id='" + toActId + "']/ExtendNodes/extendNode[@key='" + "isFilter" + "']/@value";
            String queryModuleUrlPath = "/ProcessDefine/ProcessProperty/ExtendNodes/extendNode[@key='module_url']/@value";
            String participantType = actEle.getParticipantType();
            String processDefContent = this.bpservice.queryFlowContent(null, processInstId, "");
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read((Reader)new StringReader(processDefContent));
                String moduleUrl = document.selectSingleNode(moduleUrlPath).getText();
                ArrayList<Long> receiveIds = new ArrayList<Long>();
                if ("TH".equals(TH)) {
                    String receive = this.getLastDealPerson(processInstId, toActId);
                    receiveIds.add(Long.valueOf(receive));
                } else if ("process-starter".equals(participantType)) {
                    Processinst processinst = (Processinst)this.pinstservice.find(processInstId);
                    receiveIds.add(Long.parseLong(processinst.getCreator()));
                } else if ("act-logic".equals(participantType)) {
                    String beanName = actEle.getParticiLogic();
                    IParticipantService action = (IParticipantService)ProcessEnginerHolder.getInstance().getApplicationContext().getBean(beanName, IParticipantService.class);
                    IProcessInstanceService procInstService = ProcessEnginerHolder.getInstance().getProcessInstanceService();
                    List partlist = action.createWorkItemParticipants(procInstService.findProcessById(processInstId.longValue()), toActId);
                    Iterator iterator = partlist.iterator();
                    while (iterator.hasNext()) {
                        Participant p = (Participant)iterator.next();
                        receiveIds.add(Long.parseLong(p.getParticipant()));
                    }
                } else {
                    List partlist = actEle.getParticipants();
                    Node node = document.selectSingleNode(filterPath);
                    StringBuilder role = new StringBuilder();
                    for (Participant p : partlist) {
                        if ("person".equals(p.getParticType())) {
                            Long uId = Long.valueOf(p.getParticipant());
                            if (node != null && Boolean.valueOf(node.getText()).booleanValue()) {
                                FwUser user = (FwUser)this.fwUserService.find((Serializable)uId);
                                if (user == null || !user.getOrgId().getId().equals(deptId)) continue;
                                receiveIds.add(uId);
                                continue;
                            }
                            receiveIds.add(uId);
                            continue;
                        }
                        if (!"role".equals(p.getParticType())) continue;
                        role.append("'" + p.getParticipant() + "',");
                    }
                    if (role.length() > 0) {
                        role.deleteCharAt(role.length() - 1);
                    }
                    if (node != null && Boolean.valueOf(node.getText()).booleanValue()) {
                        if (role.length() > 0) {
                            List<Long> ids = this.getNextStepPerson(deptId, role.toString());
                            receiveIds.addAll(ids);
                            this.redefinedParticipant(processInstId, ids);
                        }
                    } else if (role.length() > 0) {
                        receiveIds.addAll(this.getNextStepPerson(null, role.toString()));
                    }
                }
                String flowName = this.bpservice.getFlowNameByProcessInstId(processInstId);
                FwPendingMessage fwPendingMsg = new FwPendingMessage();
                String smd = "TH".equals(TH) ? "...\u5df2\u88ab\u9000\u56de" : "...\u9700\u8981\u60a8\u5ba1\u6838";
                fwPendingMsg.setMsgTitle("\u3010" + msgTitle + "\u3011" + flowName + smd);
                fwPendingMsg.setMsgUrl(moduleUrl);
                fwPendingMsg.setSendId(userId);
                fwPendingMsg.setBusinessId(businessId);
                fwPendingMsg.setProcessInstId(processInstId);
                String queryModuleUrl = document.selectSingleNode(queryModuleUrlPath).getText();
                fwPendingMsg.setDetailUrl(queryModuleUrl);
                for (Long receiveId : receiveIds) {
                    FwPendingDetails fwPendingDetail = new FwPendingDetails();
                    fwPendingDetail.setReceiverId(receiveId);
                    fwPendingMsg.addPendingDetails(fwPendingDetail);
                }
                this.fwPendingMessageService.save((Object)fwPendingMsg);
            }
            catch (DocumentException e) {
                this.logger.error((Object)"\u53d1\u9001\u6d88\u606f\u65f6\u89e3\u6790xml\u5931\u8d25\uff01");
                throw new ServiceException("\u6d41\u7a0bXML\u6587\u4ef6\u89e3\u6790\u5931\u8d25!");
            }
            catch (Exception e) {
                this.logger.error((Object)"\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff01");
                throw new ServiceException("\u53d1\u9001\u6d88\u606f\u5931\u8d25!", (Throwable)e);
            }
        }
        if (isAllWorkDoned && "act_finish".equals(toActId)) {
            String queryModuleUrlPath = "/ProcessDefine/ProcessProperty/ExtendNodes/extendNode[@key='module_url']/@value";
            String processDefContent = this.bpservice.queryFlowContent(null, processInstId, "");
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read((Reader)new StringReader(processDefContent));
                if (document.selectNodes(queryModuleUrlPath) != null && document.selectNodes(queryModuleUrlPath).size() != 0) {
                    String queryModuleUrl = document.selectSingleNode(queryModuleUrlPath).getText();
                    String tableName = this.getFlowTableName(processInstId);
                    Long createBy = this.queryCreateBy(tableName, processInstId);
                    String flowName = this.bpservice.getFlowNameByProcessInstId(processInstId);
                    FwPendingMessage fwPendingMsg = new FwPendingMessage();
                    fwPendingMsg.setMsgTitle("\u3010" + msgTitle + "\u3011" + flowName + "...\u5ba1\u6838\u7ed3\u675f");
                    fwPendingMsg.setMsgUrl(queryModuleUrl);
                    fwPendingMsg.setSendId(userId);
                    fwPendingMsg.setBusinessId(businessId);
                    fwPendingMsg.setBusiType(FwPendingMessage.MessageType.message);
                    fwPendingMsg.setProcessInstId(processInstId);
                    fwPendingMsg.setDetailUrl(queryModuleUrl);
                    FwPendingDetails fwPendingDetail = new FwPendingDetails();
                    fwPendingDetail.setReceiverId(createBy);
                    fwPendingMsg.addPendingDetails(fwPendingDetail);
                    this.fwPendingMessageService.save((Object)fwPendingMsg);
                }
            }
            catch (DocumentException e) {
                this.logger.error((Object)"\u53d1\u9001\u6d88\u606f\u65f6\u89e3\u6790xml\u5931\u8d25\uff01");
                throw new ServiceException("\u6d41\u7a0bXML\u6587\u4ef6\u89e3\u6790\u5931\u8d25!");
            }
            catch (Exception e) {
                this.logger.error((Object)"\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff01");
                throw new ServiceException("\u53d1\u9001\u6d88\u606f\u5931\u8d25!", (Throwable)e);
            }
        }
    }

    private Long queryCreateBy(String tableName, Long processInstId) {
        String idSql = "select t.create_by from " + tableName + " t where t.PROCESSINSTID=?0";
        Object createBy = this.flowUtilDao.getSingal(idSql, new Object[]{processInstId});
        if (createBy != null) {
            return Long.parseLong(String.valueOf(createBy));
        }
        this.logger.error((Object)"\u6d41\u7a0b\u7ed3\u675f\u65f6\u672a\u627e\u5230\u53d1\u8d77\u4eba\uff01");
        throw new ServiceException("\u6d41\u7a0b\u7ed3\u675f\u65f6\u672a\u627e\u5230\u53d1\u8d77\u4eba\uff01");
    }

    private Long updateBusinessStatus(Long processInstId, int status) {
        String tableName = this.getFlowTableName(processInstId);
        if (tableName != null) {
            String updateSql = "update " + tableName + " t set t.AUDIT_STATUS=?0 where t.PROCESSINSTID=?1";
            this.flowUtilDao.exeNativeSQL(updateSql, new Object[]{String.valueOf(status), processInstId});
            String idSql = "select t.id from " + tableName + " t where t.PROCESSINSTID=?0";
            Object oid = this.flowUtilDao.getSingal(idSql, new Object[]{processInstId});
            if (oid != null) {
                return Long.parseLong(String.valueOf(oid));
            }
            this.logger.error((Object)"\u66f4\u65b0\u4e1a\u52a1\u72b6\u6001\u65f6\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u4e1a\u52a1\u8868\uff01");
            throw new ServiceException("\u66f4\u65b0\u4e1a\u52a1\u72b6\u6001\u65f6\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u4e1a\u52a1\u8868");
        }
        this.logger.error((Object)"\u66f4\u65b0\u4e1a\u52a1\u72b6\u6001\u65f6\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u4e1a\u52a1\u8868\uff01");
        throw new ServiceException("\u66f4\u65b0\u4e1a\u52a1\u72b6\u6001\u65f6\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u4e1a\u52a1\u8868");
    }

    private String getLastDealPerson(Long processInstId, String toActId) {
        String sql = "SELECT t.participant\n          FROM wf_workitem t\n         WHERE t.processinstid = " + processInstId + "\n" + "           AND t.activitydefid = '" + toActId + "'\n" + "\t\t\tAND t.currentstate=12\n" + "         ORDER BY t.workitemid DESC";
        Object ob = this.flowUtilDao.getSingal(sql);
        String participant = "";
        if (ob != null) {
            participant = ob.toString();
        }
        return participant;
    }

    private List<Long> getNextStepPerson(Long deptId, String roles) throws Exception {
        ArrayList<Long> userIds = new ArrayList<Long>();
        String sql = "select distinct u.id\n  from fw_user u, fw_user_roles ur\n where u.id = ur.user_id\n   and ur.role_id in (" + roles + ")\n";
        if (deptId != null) {
            sql = sql + "and u.org_id = " + deptId + "\n";
        }
        try {
            List result = this.flowUtilDao.findByNativeSQL(sql, new int[0]);
            if (result != null) {
                for (BigDecimal row : result) {
                    userIds.add(row.longValue());
                }
            }
            return userIds;
        }
        catch (Exception e) {
            throw new Exception("\u4e0b\u4e00\u6b65\u5904\u7406\u4eba\u5458\u672a\u627e\u5230", e);
        }
    }

    private void endWorkItemWhenTh(Long userId, Long processinstid, Long workItemId) {
        String sql = "update wf_workitem t\nset t.currentstate=7,t.participant=?0\n WHERE t.processinstid = ?1\n   AND t.workitemid <> ?2\n   AND t.currentstate IN (4, 10)";
        this.flowUtilDao.exeNativeSQL(sql, new Object[]{userId, processinstid, workItemId});
    }

    public boolean isAllWorkItemIsDoneWhenPass(Long processinstid, Long workItemId) {
        String sql = "select count(*) from wf_workitem t\n WHERE t.processinstid = ?0\n   AND t.workitemid <> ?1\n   AND t.currentstate IN (4, 10)";
        Object ob = this.flowUtilDao.getSingal(sql, new Object[]{processinstid, workItemId});
        if (ob != null) {
            return ob.toString().equals("0");
        }
        return true;
    }

    private String getFlowName(String tablename) {
        String sql = "select t.design_name from STF_BUSINESS_PROCESS t where TRIM(Upper(t.business_table))=TRIM(Upper(?0))";
        Object ob = this.flowUtilDao.getSingal(sql, new Object[]{tablename});
        if (ob != null) {
            return ob.toString();
        }
        return null;
    }

    private String getFlowTableName(Long processInstId) {
        String tsql = "SELECT p.business_table\n  FROM wf_processinst       t,\n       stf_business_process p\n WHERE t.processinstid = ?0\n   AND p.design_name = t.processinstname";
        Object ob = this.flowUtilDao.getSingal(tsql, new Object[]{processInstId});
        if (ob != null) {
            return ob.toString();
        }
        return null;
    }

    public Long getAcntIdByProcessInstId(Long processInstId) {
        String table = this.getFlowTableName(processInstId);
        String tsql = "SELECT t.acnt_id\n  FROM " + table + "       t\n" + " WHERE t.processinstid = ?0\n";
        Object ob = this.flowUtilDao.getSingal(tsql, new Object[]{processInstId});
        if (ob != null) {
            return Long.parseLong(ob.toString());
        }
        return null;
    }

    public Long getWorkItemId(Long processInstId, String userId) {
        String roleSql = "select t1.role_id\n  from FW_USER_ROLES t1,fw_user t2\n where t1.user_id=t2.id and t2.id =" + userId;
        String sql = "SELECT b.WORKITEMID FROM wf_participant a, wf_workitem b WHERE ((a.PARTICTYPE = 'person' AND a.Participant = '" + userId + "')" + " OR (a.PARTICTYPE = 'role' AND a.PARTICIPANT in (" + roleSql + "))" + " OR (a.PARTICTYPE = 'organization' AND a.PARTICIPANT = '" + userId + "'))" + " AND b.CURRENTSTATE IN(4,10) AND a.WORKITEMID = b.WORKITEMID" + " AND b.PROCESSINSTID = '" + processInstId + "'";
        Long workitemid = null;
        Object ob = this.flowUtilDao.getSingal(sql);
        if (ob != null) {
            workitemid = Long.valueOf(this.flowUtilDao.getSingal(sql).toString());
        }
        return workitemid;
    }

    public Long getWorkItemId(Long processInstId) {
        String sql = "SELECT b.WORKITEMID  FROM  wf_workitem b where b.CURRENTSTATE IN(4,10)  AND b.PROCESSINSTID = '" + processInstId + "' and rownum=1";
        Long workitemid = null;
        Object ob = this.flowUtilDao.getSingal(sql);
        if (ob != null) {
            workitemid = Long.valueOf(this.flowUtilDao.getSingal(sql).toString());
        }
        return workitemid;
    }

    @Transactional(readOnly=true)
    public List<Long> queryDealedProcess(Long userId, WorkItemEnum workStatus) {
        String tempsql = "";
        tempsql = WorkItemEnum.passed.equals((Object)workStatus) || WorkItemEnum.reported.equals((Object)workStatus) ? " =12 " : " IN (4, 10) ";
        String sql = "SELECT DISTINCT a.processinstid \n  FROM wf_workitem a\n  LEFT JOIN wf_participant b\n    ON a.workitemid = b.workitemid\n  LEFT JOIN fw_user_roles r\n    ON r.role_id = b.participant\n   AND b.partictype = 'role'\n WHERE a.currentstate " + tempsql + "\n" + "   AND (r.user_id = ?0 OR (b.participant = ?0 AND b.partictype = 'person'))";
        ArrayList<Long> list = new ArrayList<Long>();
        List ol = this.flowUtilDao.findByNativeSQL(sql, new Object[]{userId}, new int[0]);
        if (ol != null && !ol.isEmpty()) {
            for (Object ob : ol) {
                Long processinstid = Long.parseLong(ob.toString());
                list.add(processinstid);
            }
        } else {
            list.add(-1L);
        }
        return list;
    }

    public IProcessInstanceService getProcInstService() {
        return this.procInstService;
    }

    public IWorkItemService getWorkItemService() {
        return this.workItemService;
    }

    public Long getProCessDefId(Long processinstId) {
        String sql = "SELECT a.PROCESSDEFID FROM wf_processinst a WHERE a.PROCESSINSTID = ?0";
        Object ob = this.flowUtilDao.getSingal(sql, new Long[]{processinstId});
        Long proCessDefId = null;
        if (ob != null) {
            proCessDefId = Long.valueOf(ob.toString());
        }
        return proCessDefId;
    }

    private void cleanRelvant_data(Long processinstId, String activitydefId) {
        String delsql = "delete from wf_relevant_data where PROCESSINSTID = ?0 and ACTIVITYDEFID = ?1 and NAME = ?2";
        this.flowUtilDao.exeNativeSQL(delsql, new Object[]{processinstId, activitydefId, "transitionExpressCondition"});
    }

    public void redefinedParticipant(Long processinstId, List<Long> ids) {
        Long workItemId = this.getWorkItemId(processinstId);
        if (workItemId != null) {
            String delsql = "delete from WF_PARTICIPANT where workitemid = ?0 ";
            this.flowUtilDao.exeNativeSQL(delsql, new Object[]{workItemId});
            String insertSql = "insert into WF_PARTICIPANT (PARTICID, WORKITEMID, PARTICTYPE, PARTICIPANT, PARTICIPANT2)\nvalues (?0, ?1, ?2, ?3, ?4)";
            for (Long id : ids) {
                FwUser user = (FwUser)this.fwUserService.find((Serializable)id);
                if (user == null) continue;
                this.flowUtilDao.exeNativeSQL(insertSql, new Object[]{PrimaryKeyUtil.getPrimaryKey((String)"participantId"), workItemId, "person", id, user.getUsername()});
            }
        }
    }
}

