/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.usiflow.webframe.web.controller.statistics;

import com.kdgc.framework.web.controller.BaseController;
import com.kdgc.usiflow.webframe.core.util.StrUtil;
import com.kdgc.usiflow.webframe.web.service.statistics.WorkLoadService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/workVolume"})
public class WorkLoadController
extends BaseController {
    @Autowired
    private WorkLoadService workLoadService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "statistics/workLoad";
    }

    @RequestMapping(value={"/queryWorkLoad"})
    @ResponseBody
    public void queryWorkLoad(Long orgid, String yearPre, String yearNext, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = this.workLoadService.queryWorkLoad(orgid, yearPre, yearNext);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (Map<String, Object> map : list) {
            String createValue = "0";
            if (map.get("createValue") != null) {
                createValue = map.get("createValue").toString();
            }
            String finishValue = "0";
            if (map.get("finishValue") != null) {
                finishValue = map.get("finishValue").toString();
            }
            sb.append("<node orgid=\"" + String.valueOf(map.get("orgid")) + "\" orgname=\"" + StrUtil.encodeString(String.valueOf(map.get("orgname"))) + "\" createValue=\"" + createValue + "\" finishValue=\"" + finishValue + "\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryWorkLoadSub"})
    @ResponseBody
    public void queryWorkLoadSub(Long orgid, String yearPre, String yearNext, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = this.workLoadService.queryWorkLoadSub(orgid, yearPre, yearNext);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (Map<String, Object> map : list) {
            String createValue = "0";
            if (map.get("createValue") != null) {
                createValue = map.get("createValue").toString();
            }
            String finishValue = "0";
            if (map.get("finishValue") != null) {
                finishValue = map.get("finishValue").toString();
            }
            sb.append("<node orgid=\"" + String.valueOf(map.get("orgid")) + "\" orgname=\"" + StrUtil.encodeString(String.valueOf(map.get("orgname"))) + "\" createValue=\"" + createValue + "\" finishValue=\"" + finishValue + "\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryWorkLoadYear"})
    @ResponseBody
    public void queryWorkLoadYear(Long orgid, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = this.workLoadService.queryWorkLoadYear(orgid);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (Map<String, Object> map : list) {
            String createValue = "0";
            if (map.get("createValue") != null) {
                createValue = map.get("createValue").toString();
            }
            String finishValue = "0";
            if (map.get("finishValue") != null) {
                finishValue = map.get("finishValue").toString();
            }
            sb.append("<node yearvalue=\"" + String.valueOf(map.get("yearvalue")) + "\" createValue=\"" + createValue + "\" finishValue=\"" + finishValue + "\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryWorkLoadMonth"})
    @ResponseBody
    public void queryWorkLoadMonth(Long orgid, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = this.workLoadService.queryWorkLoadMonth(orgid);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (Map<String, Object> map : list) {
            String month;
            String createValue = "0";
            if (map.get("createValue") != null) {
                createValue = map.get("createValue").toString();
            }
            String finishValue = "0";
            if (map.get("finishValue") != null) {
                finishValue = map.get("finishValue").toString();
            }
            if ((month = String.valueOf(map.get("monthvalue"))).length() == 1) {
                month = "0" + month;
            }
            sb.append("<node yearvalue=\"" + String.valueOf(map.get("yearvalue")) + "\" monthvalue=\"" + month + "\" createValue=\"" + "\" createValue=\"" + createValue + "\" finishValue=\"" + finishValue + "\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }
}

