/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.usiflow.webframe.web.controller.flowexcute;

import com.kdgc.framework.modules.security.shiro.Principal;
import com.kdgc.framework.modules.utils.JSONUtil;
import com.kdgc.framework.modules.utils.StringUtils;
import com.kdgc.framework.web.common.ResponseData;
import com.kdgc.framework.web.controller.BaseController;
import com.kdgc.usiflow.webframe.core.util.ComparatorLine;
import com.kdgc.usiflow.webframe.flow.ProcessEnginerHolder;
import com.kdgc.usiflow.webframe.web.model.flow.LineCondition;
import com.kdgc.usiflow.webframe.web.service.flow.FlowUtilService;
import com.ustcsoft.usiflow.engine.model.WorkItem;
import com.ustcsoft.usiflow.engine.repository.IWorkItemRepository;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/wf"})
public class WorkFlowController
extends BaseController {
    private static final long serialVersionUID = -7692965489332253558L;
    @Autowired
    private FlowUtilService flowUtilservice;

    private Long getCurrentUserId() {
        Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
        return principal.getId();
    }

    @RequestMapping(value={"/flowSubmit"})
    public String flowSubmit() {
        return "/pm/workflow/flowSubmit";
    }

    @RequestMapping(value={"/getLineCondition"})
    public Object getLineCondition(HttpServletRequest requestServlet, ModelMap model, Long processInstId, String cond, Long deptId, String msgTitle, String callback) {
        Map condtions = StringUtils.isEmpty((CharSequence)cond) ? new HashMap() : (Map)JSONUtil.readValue((String)cond, Map.class);
        Long workitemid = this.flowUtilservice.getWorkItemId(processInstId, this.getCurrentUserId().toString().toString());
        if (workitemid != null) {
            IWorkItemRepository workItemRep = (IWorkItemRepository)ProcessEnginerHolder.getInstance().getApplicationContext().getBean(IWorkItemRepository.class);
            WorkItem workItem = workItemRep.findWorkItem(workitemid.longValue());
            List<LineCondition> list = this.flowUtilservice.getLineCondition(workItem, this.getCurrentUserId(), condtions);
            if (list != null && !list.isEmpty()) {
                ComparatorLine comparator = new ComparatorLine();
                Collections.sort(list, comparator);
            } else {
                requestServlet.setAttribute("flag", (Object)"0");
            }
            requestServlet.setAttribute("isAllDone", (Object)this.flowUtilservice.isAllWorkItemIsDoneWhenPass(processInstId, workitemid));
            requestServlet.setAttribute("lineList", list);
            requestServlet.setAttribute("actId", (Object)workItem.getActivityDefId());
        } else {
            requestServlet.setAttribute("flag", (Object)"0");
        }
        requestServlet.setAttribute("deptId", (Object)deptId);
        requestServlet.setAttribute("processInstId", (Object)processInstId);
        requestServlet.setAttribute("msgTitle", (Object)msgTitle);
        requestServlet.setAttribute("callback", (Object)callback);
        return "/workflow/flowSubmit";
    }

    @RequestMapping(value={"/getBatchLineCondition"})
    public Object getBatchLineCondition(HttpServletRequest requestServlet, ModelMap model, String processInstIds, String cond, Long deptId, String msgTitle, String callback) {
        String[] processInstIdArrays = processInstIds.split(",");
        Long processInstId = Long.valueOf(processInstIdArrays[0]);
        Map condtions = StringUtils.isEmpty((CharSequence)cond) ? new HashMap() : (Map)JSONUtil.readValue((String)cond, Map.class);
        Long workitemid = this.flowUtilservice.getWorkItemId(processInstId, this.getCurrentUserId().toString().toString());
        if (workitemid != null) {
            IWorkItemRepository workItemRep = (IWorkItemRepository)ProcessEnginerHolder.getInstance().getApplicationContext().getBean(IWorkItemRepository.class);
            WorkItem workItem = workItemRep.findWorkItem(workitemid.longValue());
            List<LineCondition> list = this.flowUtilservice.getLineCondition(workItem, this.getCurrentUserId(), condtions);
            if (list != null && !list.isEmpty()) {
                ComparatorLine comparator = new ComparatorLine();
                Collections.sort(list, comparator);
            } else {
                requestServlet.setAttribute("flag", (Object)"0");
            }
            requestServlet.setAttribute("isAllDone", (Object)this.flowUtilservice.isAllWorkItemIsDoneWhenPass(processInstId, workitemid));
            requestServlet.setAttribute("lineList", list);
            requestServlet.setAttribute("actId", (Object)workItem.getActivityDefId());
        } else {
            requestServlet.setAttribute("flag", (Object)"0");
        }
        requestServlet.setAttribute("deptId", (Object)deptId);
        requestServlet.setAttribute("processInstId", (Object)processInstIds);
        requestServlet.setAttribute("msgTitle", (Object)msgTitle);
        requestServlet.setAttribute("callback", (Object)callback);
        return "/workflow/flowSubmit";
    }

    @RequestMapping(value={"/getCurActId"})
    @ResponseBody
    public Object getCurActId(HttpServletRequest requestServlet, Long processInstId) {
        Long workitemid = this.flowUtilservice.getWorkItemId(processInstId);
        if (workitemid != null) {
            IWorkItemRepository workItemRep = (IWorkItemRepository)ProcessEnginerHolder.getInstance().getApplicationContext().getBean(IWorkItemRepository.class);
            WorkItem workItem = workItemRep.findWorkItem(workitemid.longValue());
            return workItem.getActivityDefId();
        }
        return -1;
    }

    @RequestMapping(value={"/excuteFlow"})
    @ResponseBody
    public Object excuteFlow(HttpServletRequest requestServlet, Long processInstId, Long deptId, String msgTitle, String condition, String toActId, String TH, String advice) throws Exception {
        Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
        Map<String, Object> result = this.flowUtilservice.excuteFlow(processInstId, principal.getId(), deptId, msgTitle, condition, toActId, TH, advice);
        return new ResponseData(ResponseData.Type.info, "\u6d41\u7a0b\u6d41\u8f6c\u53d1\u9001\u6210\u529f", result);
    }

    @RequestMapping(value={"/excuteBatchFlow"})
    @ResponseBody
    public Object excuteBatchFlow(HttpServletRequest requestServlet, String processInstIds, Long deptId, String msgTitle, String condition, String toActId, String TH, String advice) throws Exception {
        Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
        String[] processInstIdArrays = processInstIds.split(",");
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (String processInstId : processInstIdArrays) {
            Map<String, Object> result = this.flowUtilservice.excuteFlow(Long.valueOf(processInstId), principal.getId(), deptId, msgTitle, condition, toActId, TH, advice);
            results.putAll(result);
        }
        return new ResponseData(ResponseData.Type.info, "\u6d41\u7a0b\u6d41\u8f6c\u53d1\u9001\u6210\u529f", results);
    }
}

