/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.usiflow.webframe.web.controller.flowadmin;

import com.kdgc.framework.web.controller.BaseController;
import com.kdgc.usiflow.webframe.flow.FlowSpringBeanUtil;
import com.kdgc.usiflow.webframe.web.model.flowadmin.FlowScaleStatics;
import com.kdgc.usiflow.webframe.web.service.flow.BusinessTypeService;
import com.kdgc.usiflow.webframe.web.service.flowadmin.FlowScaleStaticsService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/flowScale"})
public class FlowScaleStaticsController
extends BaseController {
    @Autowired
    private BusinessTypeService businessTypeService;
    @Autowired
    private FlowScaleStaticsService flowScaleStaticsService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "workflow/flowScaleStatics";
    }

    @RequestMapping(value={"/queryScaleStatics"})
    @ResponseBody
    public void queryScaleStatics(FlowScaleStatics flowScaleStatics, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> listnew = this.flowScaleStaticsService.queryBusinessProcessnew(flowScaleStatics);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (Map<String, Object> m : listnew) {
            sb.append("<node flowid=\"" + m.get("DESIGN_NAME") + "\" flowname=\"" + m.get("FLOW_NAME") + "\" runcount=\"" + m.get("RUNCOUNT") + "\" stopcount=\"" + m.get("STOPCOUNT") + "\" finishcount=\"" + m.get("FINISHCOUNT") + "\" >\n");
            sb.append("</node>");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/querySecScaleStatics"})
    @ResponseBody
    public void querySecScaleStatics(FlowScaleStatics flowScaleStatics, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> listnew = this.flowScaleStaticsService.queryBusinessProcessSecnew(flowScaleStatics);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (Map<String, Object> m : listnew) {
            sb.append("<node flowid=\"" + m.get("PROCESSDEFID") + "\" flowname=\"" + m.get("PROCESSCHNAME") + "(" + m.get("VERSIONSIGN") + ")" + "\" runcount=\"" + m.get("RUNCOUNT") + "\" stopcount=\"" + m.get("STOPCOUNT") + "\" finishcount=\"" + m.get("FINISHCOUNT") + "\" >\n");
            sb.append("</node>");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryThreeScaleStatics"})
    @ResponseBody
    public void queryThreeScaleStatics(FlowScaleStatics flowScaleStatics, HttpServletResponse response) throws IOException {
        String yearinfo = "";
        List<Map<String, Object>> listnew = this.flowScaleStaticsService.queryBusinessProcessThreenew(flowScaleStatics);
        if (listnew != null && listnew.size() != 0) {
            Map<String, Object> m = listnew.get(0);
            Map<String, Object> m1 = listnew.get(listnew.size() - 1);
            if (m.get("YEARINFO") != null && m1.get("YEARINFO") != null) {
                yearinfo = m.get("YEARINFO").toString() + "-" + m1.get("YEARINFO");
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (Map<String, Object> m : listnew) {
            sb.append("<node flowid=\"" + yearinfo + "\" flowname=\"" + m.get("YEARINFO") + "-" + m.get("MONTHINFO") + "\" runcount=\"" + m.get("RUNCOUNT") + "\" stopcount=\"" + m.get("STOPCOUNT") + "\" finishcount=\"" + m.get("FINISHCOUNT") + "\" >\n");
            sb.append("</node>");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/querySpringBeannew"})
    @ResponseBody
    public void querySpringBeannew(String type, HttpServletResponse response) throws IOException {
        StringBuilder sb = new StringBuilder();
        List<String> list = FlowSpringBeanUtil.querySpringBean(type);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (String name : list) {
            sb.append("<node value=\"" + name + "\" />\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }
}

