/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.usiflow.webframe.web.controller.flowadmin;

import com.kdgc.framework.web.common.ResponseData;
import com.kdgc.framework.web.controller.BaseController;
import com.kdgc.usiflow.webframe.flow.ProcessEnginerHolder;
import com.kdgc.usiflow.webframe.web.model.flow.Activityinst;
import com.kdgc.usiflow.webframe.web.service.flow.ActivityinstService;
import com.ustcsoft.usiflow.engine.service.IActivityInstService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/activityinstAdmin"})
public class ActivityinstController
extends BaseController {
    @Autowired
    private ActivityinstService activityinstService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "workflow/activityinst";
    }

    @RequestMapping(value={"/activityinst"})
    public void activityinst() {
    }

    @RequestMapping(value={"/queryActivityinsts"})
    @ResponseBody
    public void queryActivityinsts(Long processinstid, HttpServletResponse response) throws IOException {
        List<Activityinst> list = this.activityinstService.queryActivityinst(processinstid);
        ArrayList<Activityinst> temp = new ArrayList<Activityinst>();
        for (Activityinst activityinst : list) {
            temp.add(activityinst);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (int i = 0; i < temp.size(); ++i) {
            sb.append("<node activityinstid=\"" + ((Activityinst)temp.get(i)).getActivityinstid() + "\" activityinstname=\"" + ((Activityinst)temp.get(i)).getActivityinstname() + "\" activitytype=\"" + ((Activityinst)temp.get(i)).getActivitytype() + "\" currentstate=\"" + ((Activityinst)temp.get(i)).getCurrentstate() + "\" starttime=\"" + ((Activityinst)temp.get(i)).getStarttime() + "\" endtime=\"" + ((Activityinst)temp.get(i)).getEndtime() + "\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/insertActivityinst"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData insertActivityinst(Activityinst activityinst) {
        this.activityinstService.save(activityinst);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/updateActivityinst"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData updateActivityinst(Activityinst activityinst) {
        this.activityinstService.update(activityinst);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/loadActivityinst"}, method={RequestMethod.POST})
    @ResponseBody
    public Activityinst loadActivityinst(Long id) {
        return (Activityinst)this.activityinstService.find(id);
    }

    @RequestMapping(value={"/deleteActivityinst"})
    @ResponseBody
    public ResponseData deleteActivityinst(long id) {
        this.activityinstService.delete(Long.valueOf(id));
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/finishActivity"})
    @ResponseBody
    public Long finishActivity(long activityinstid) {
        IActivityInstService activityInstService = ProcessEnginerHolder.getInstance().getActivityInstService();
        Long activityinst = 0L;
        activityInstService.finishActivity(activityinstid);
        return activityinst;
    }

    @RequestMapping(value={"/restartActivity"})
    @ResponseBody
    public Long restartActivity(long activityinstid, long processInstId) {
        IActivityInstService activityInstService = ProcessEnginerHolder.getInstance().getActivityInstService();
        Long activityinst = 0L;
        activityInstService.restartActivity(processInstId, activityinstid);
        return activityinst;
    }

    @RequestMapping(value={"/handUpActivity"})
    @ResponseBody
    public Long handUpActivity(long activityinstid) {
        Long activityinst = 0L;
        this.updateCurrentstate(activityinstid, 2L);
        return activityinst;
    }

    @RequestMapping(value={"/recoverActivity"})
    @ResponseBody
    public Long recoverActivity(long activityinstid, String activityDefId) {
        IActivityInstService activityInstService = ProcessEnginerHolder.getInstance().getActivityInstService();
        Long activityinst = 0L;
        activityInstService.startActivityInst(activityinstid, activityDefId);
        return activityinst;
    }

    @RequestMapping(value={"/activeActivity"})
    @ResponseBody
    public Long activeActivity(long activityinstid) {
        IActivityInstService activityInstService = ProcessEnginerHolder.getInstance().getActivityInstService();
        Long activityinst = 0L;
        activityInstService.activateActivity(activityinstid);
        return activityinst;
    }

    @RequestMapping(value={"/stopActivity"})
    @ResponseBody
    public Long stopActivity(long activityinstid) {
        IActivityInstService activityInstService = ProcessEnginerHolder.getInstance().getActivityInstService();
        Long activityinst = 0L;
        activityInstService.terminateActivity(activityinstid);
        return activityinst;
    }

    private void updateCurrentstate(Long activityinstid, Long currentstate) {
        Activityinst activityinst = (Activityinst)this.activityinstService.find(activityinstid);
        activityinst.setCurrentstate(currentstate);
        this.activityinstService.update(activityinst);
    }

    @RequestMapping(value={"/backActivity"})
    @ResponseBody
    public Long backActivity(long activityinstid, String backType) {
        Long activityinst = 0L;
        IActivityInstService activityInstService = ProcessEnginerHolder.getInstance().getActivityInstService();
        if (backType.equals("1")) {
            activityInstService.rollbackToActivityFroOneStep(activityinstid);
        } else if (backType.equals("2")) {
            activityInstService.rollbackToActivityFroRecentManual(activityinstid);
        }
        return activityinst;
    }
}

