/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.usiflow.webframe.web.controller.flow;

import com.kdgc.framework.dao.support.Filter;
import com.kdgc.framework.dao.support.Order;
import com.kdgc.framework.web.common.ResponseData;
import com.kdgc.framework.web.controller.BaseController;
import com.kdgc.usiflow.webframe.web.model.flow.BusinessType;
import com.kdgc.usiflow.webframe.web.model.flow.PageTemplate;
import com.kdgc.usiflow.webframe.web.service.flow.BusinessTypeService;
import com.kdgc.usiflow.webframe.web.service.flow.PageTemplateService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pageTemplate"})
public class PageTemplateController
extends BaseController {
    @Autowired
    private BusinessTypeService businessTypeService;
    @Autowired
    private PageTemplateService pageTemplateService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "workflow/pageTemplate";
    }

    @RequestMapping(value={"/queryPageTemplates"})
    @ResponseBody
    public List queryPageTemplates(Long node, @RequestParam(required=false) String leafNode) {
        if (node == null) {
            node = 0L;
        }
        if (StringUtils.hasText((String)leafNode) && "Y".equals(leafNode)) {
            ArrayList<Filter> filterList = new ArrayList<Filter>();
            Filter filter = new Filter("businessTypeId", Filter.Operator.eq, (Object)node);
            filterList.add(filter);
            ArrayList<Order> orderList = new ArrayList<Order>();
            Order order = new Order("id", Order.Direction.asc);
            orderList.add(order);
            List list = this.pageTemplateService.findList(null, filterList, orderList);
            return list;
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        Filter filter = new Filter("parentId", Filter.Operator.eq, (Object)node);
        filterList.add(filter);
        ArrayList<Order> orderList = new ArrayList<Order>();
        Order order = new Order("orderIndex", Order.Direction.asc);
        orderList.add(order);
        List list = this.businessTypeService.findList(null, filterList, orderList);
        for (BusinessType businessType : list) {
            businessType.setLeaf(false);
            if (!"Y".equals(businessType.getLeafNode())) continue;
            businessType.setIconCls("leaf");
        }
        return list;
    }

    @RequestMapping(value={"/queryPageTemplates4Flex"})
    @ResponseBody
    public void queryPageTemplates4Flex(Long busiId, HttpServletResponse response) throws IOException {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        Filter filter = new Filter("businessTypeId", Filter.Operator.eq, (Object)busiId);
        filterList.add(filter);
        ArrayList<Order> orderList = new ArrayList<Order>();
        Order order = new Order("id", Order.Direction.asc);
        orderList.add(order);
        ArrayList list = new ArrayList();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (PageTemplate template : list) {
            sb.append("<node id=\"" + template.getId() + "\" name=\"" + template.getName() + "\" />\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/insertPageTemplate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData insertPageTemplate(PageTemplate pageTemplate) {
        this.pageTemplateService.save(pageTemplate);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/updatePageTemplate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData updatePageTemplate(PageTemplate pageTemplate) {
        this.pageTemplateService.update(pageTemplate);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/loadPageTemplate"}, method={RequestMethod.POST})
    @ResponseBody
    public PageTemplate loadPageTemplate(String id) {
        String _id = id.substring(id.indexOf(".") + 1);
        return (PageTemplate)this.pageTemplateService.find(Long.valueOf(_id));
    }

    @RequestMapping(value={"/deletePageTemplate"})
    @ResponseBody
    public ResponseData deletePageTemplate(String id) {
        String _id = id.substring(id.indexOf(".") + 1);
        this.pageTemplateService.delete(Long.valueOf(_id));
        return ResponseData.SUCCESS_NO_DATA;
    }
}

