/*
 * Decompiled with CFR 0.152.
 */
package com.kdgc.usiflow.webframe.web.controller.flow;

import com.kdgc.framework.dao.support.Filter;
import com.kdgc.framework.dao.support.Order;
import com.kdgc.framework.web.common.ResponseData;
import com.kdgc.framework.web.controller.BaseController;
import com.kdgc.usiflow.webframe.web.model.flow.BusinessType;
import com.kdgc.usiflow.webframe.web.model.flow.FlowOperation;
import com.kdgc.usiflow.webframe.web.service.flow.BusinessTypeService;
import com.kdgc.usiflow.webframe.web.service.flow.FlowOperationService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="operationControllerFlow")
@RequestMapping(value={"/flowOperation"})
public class FlowOperationController
extends BaseController {
    @Autowired
    private BusinessTypeService businessTypeService;
    @Autowired
    private FlowOperationService flowOperationService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "workflow/flowOperation";
    }

    @RequestMapping(value={"/queryOperations"})
    @ResponseBody
    public List queryOperations(Long node, @RequestParam(required=false) String leafNode) {
        if (node == null) {
            node = 0L;
        }
        if (StringUtils.hasText((String)leafNode) && "Y".equals(leafNode)) {
            ArrayList<Filter> filterList = new ArrayList<Filter>();
            Filter filter = new Filter("businessTypeId", Filter.Operator.eq, (Object)node);
            filterList.add(filter);
            ArrayList<Order> orderList = new ArrayList<Order>();
            Order order = new Order("id", Order.Direction.asc);
            orderList.add(order);
            List list = this.flowOperationService.findList(null, filterList, orderList);
            return list;
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        Filter filter = new Filter("parentId", Filter.Operator.eq, (Object)node);
        filterList.add(filter);
        ArrayList<Order> orderList = new ArrayList<Order>();
        Order order = new Order("orderIndex", Order.Direction.asc);
        orderList.add(order);
        List list = this.businessTypeService.findList(null, filterList, orderList);
        for (BusinessType businessType : list) {
            businessType.setLeaf(false);
            if (!"Y".equals(businessType.getLeafNode())) continue;
            businessType.setIconCls("leaf");
        }
        return list;
    }

    @RequestMapping(value={"/queryOperations4Flex"})
    @ResponseBody
    public void queryOperations4Flex(Long busiId, HttpServletResponse response) throws IOException {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        Filter filter = new Filter("businessTypeId", Filter.Operator.eq, (Object)busiId);
        filterList.add(filter);
        ArrayList<Order> orderList = new ArrayList<Order>();
        Order order = new Order("id", Order.Direction.asc);
        orderList.add(order);
        List list = this.flowOperationService.findList(null, filterList, orderList);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (FlowOperation template : list) {
            sb.append("<node id=\"" + template.getId() + "\" code=\"" + template.getCode() + "\" name=\"" + template.getName() + "\" action=\"" + template.getAction() + "\" />\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/insertOperation"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData insertOperation(FlowOperation operation) {
        this.flowOperationService.save(operation);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/updateOperation"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData updateOperation(FlowOperation operation) {
        this.flowOperationService.update(operation);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/loadOperation"}, method={RequestMethod.POST})
    @ResponseBody
    public FlowOperation loadOperation(String id) {
        String _id = id.substring(id.indexOf(".") + 1);
        return (FlowOperation)this.flowOperationService.find(Long.valueOf(_id));
    }

    @RequestMapping(value={"/deleteOperation"})
    @ResponseBody
    public ResponseData deleteOperation(String id) {
        String _id = id.substring(id.indexOf(".") + 1);
        this.flowOperationService.delete(Long.valueOf(_id));
        return ResponseData.SUCCESS_NO_DATA;
    }
}

