/*
 * Decompiled with CFR 0.152.
 */
package com.justtoplay.xxl.job.plus.discovery.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.justtoplay.xxl.job.plus.discovery.DiscoveryProvider;
import com.justtoplay.xxl.job.plus.discovery.nacos.NamingServiceHolder;
import com.justtoplay.xxl.job.plus.event.ServiceDownEvent;
import com.justtoplay.xxl.job.plus.event.ServiceRefreshEvent;
import com.justtoplay.xxl.job.plus.event.ServiceUpEvent;
import com.justtoplay.xxl.job.plus.thread.GetDiscoveryStatusThread;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={NamingService.class})
@ConditionalOnMissingBean(value={DiscoveryProvider.class})
@AutoConfigureAfter(value={NamingServiceHolder.class})
public class NacosDiscoveryProvider
implements DiscoveryProvider,
DisposableBean,
ApplicationListener<WebServerInitializedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(NacosDiscoveryProvider.class);
    @Autowired
    private NamingServiceHolder namingServiceHolder;
    @Autowired
    private ApplicationContext applicationContext;
    private String currentExecutorAddress;
    private String executorServiceName;

    public void onApplicationEvent(WebServerInitializedEvent event) {
        logger.info(">>>>>>>>>>> xxl-job-plus, NacosDiscoveryProvider init");
        if (this.namingServiceHolder != null) {
            this.currentExecutorAddress = this.namingServiceHolder.getExecutorAddress();
            this.executorServiceName = this.namingServiceHolder.getServiceName();
            GetDiscoveryStatusThread.getInstance().start(this.currentExecutorAddress, this.executorServiceName, this);
        }
    }

    @Override
    public List<String> getServiceAddressList(String serviceName) {
        try {
            List instances = this.namingServiceHolder.get().getAllInstances(serviceName, true);
            if (instances != null) {
                return instances.stream().map(instance -> instance.getIp() + ":" + instance.getPort()).collect(Collectors.toList());
            }
        }
        catch (NacosException e) {
            logger.error("NacosDiscoveryProvider getServiceAddressList error: serviceName={}, msg={}", (Object)serviceName, (Object)e.getMessage());
        }
        return new ArrayList<String>();
    }

    @Override
    public String getCurrentServiceAddress() {
        return this.currentExecutorAddress;
    }

    @Override
    public void listenCurrentServiceStatus() {
        try {
            this.namingServiceHolder.get().subscribe(this.executorServiceName, new EventListener(){

                public void onEvent(Event event) {
                    if (event instanceof NamingEvent) {
                        NamingEvent namingEvent = (NamingEvent)event;
                        if (namingEvent.getInstances().size() == 0) {
                            NacosDiscoveryProvider.this.applicationContext.publishEvent((ApplicationEvent)new ServiceDownEvent(this));
                        }
                        for (Instance instance : namingEvent.getInstances()) {
                            String address = instance.getIp() + ":" + instance.getPort();
                            if (!address.equals(NacosDiscoveryProvider.this.currentExecutorAddress)) continue;
                            if (instance.isEnabled() && instance.isHealthy()) {
                                NacosDiscoveryProvider.this.applicationContext.publishEvent((ApplicationEvent)new ServiceUpEvent(this));
                                continue;
                            }
                            NacosDiscoveryProvider.this.applicationContext.publishEvent((ApplicationEvent)new ServiceDownEvent(this));
                        }
                    }
                }
            });
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void listenServiceStatus(String serviceName) {
        try {
            this.namingServiceHolder.get().subscribe(serviceName, new EventListener(){

                public void onEvent(Event event) {
                    if (event instanceof NamingEvent) {
                        NamingEvent namingEvent = (NamingEvent)event;
                        ArrayList<String> addressList = new ArrayList<String>();
                        for (Instance instance : namingEvent.getInstances()) {
                            String address;
                            if (!instance.isEnabled() || !instance.isHealthy() || addressList.contains(address = instance.getIp() + ":" + instance.getPort())) continue;
                            addressList.add(address);
                        }
                        NacosDiscoveryProvider.this.applicationContext.publishEvent((ApplicationEvent)new ServiceRefreshEvent(this, addressList));
                    }
                }
            });
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        GetDiscoveryStatusThread.getInstance().toStop();
    }
}

