/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import com.jd.httpservice.RequestBodyConverter;
import com.jd.httpservice.agent.IllegalHttpServiceDefinitionException;
import com.jd.httpservice.converters.ByteArrayBodyConverter;
import com.jd.httpservice.converters.InputStreamBodyConverter;
import com.jd.httpservice.converters.JsonBodyConverter;
import com.jd.httpservice.converters.ObjectToStringBodyConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.util.ClassUtils;

class TypeAutoAdaptingRequestBodyConverter
implements RequestBodyConverter {
    private static final RequestBodyConverter OBJECT_TO_STRING_CONVERTER = new ObjectToStringBodyConverter();
    private static final RequestBodyConverter INPUT_STREAM_CONVERTER = new InputStreamBodyConverter();
    private static final RequestBodyConverter BYTES_CONVERTER = new ByteArrayBodyConverter();
    private RequestBodyConverter converter;

    public TypeAutoAdaptingRequestBodyConverter(Class<?> argType) {
        this.converter = this.createConverter(argType);
    }

    private RequestBodyConverter createConverter(Class<?> argType) {
        if (ClassUtils.isAssignable(InputStream.class, argType)) {
            return INPUT_STREAM_CONVERTER;
        }
        if (ClassUtils.isAssignable(String.class, argType)) {
            return OBJECT_TO_STRING_CONVERTER;
        }
        if (ClassUtils.isAssignable(byte[].class, argType)) {
            return BYTES_CONVERTER;
        }
        if (ClassUtils.isPrimitiveOrWrapper(argType)) {
            return OBJECT_TO_STRING_CONVERTER;
        }
        if (ClassUtils.isAssignable(OutputStream.class, argType)) {
            throw new IllegalHttpServiceDefinitionException("Unsupported type for the request body argument!");
        }
        return new JsonBodyConverter(argType);
    }

    @Override
    public void write(Object param, OutputStream out) throws IOException {
        if (param == null) {
            return;
        }
        this.converter.write(param, out);
    }
}

