/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import org.springframework.util.StringUtils;
import utils.net.NetworkAddress;
import utils.net.SSLSecurity;

public class ServiceEndpoint
extends NetworkAddress
implements Cloneable {
    private static final long serialVersionUID = 128018335830143965L;
    private String contextPath;
    private SSLSecurity sslSecurity;

    public ServiceEndpoint(String host, int port, boolean secure) {
        this(host, port, secure, null);
    }

    public ServiceEndpoint(NetworkAddress networkAddress) {
        this(networkAddress.getHost(), networkAddress.getPort(), networkAddress.isSecure(), null);
    }

    public ServiceEndpoint(String host, int port, boolean secure, String contextPath) {
        super(host, port, secure);
        contextPath = StringUtils.cleanPath((String)contextPath);
        this.contextPath = StringUtils.isEmpty((Object)contextPath) ? "/" : contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public SSLSecurity getSslSecurity() {
        return this.sslSecurity;
    }

    public void setSslSecurity(SSLSecurity sslSecurity) {
        this.sslSecurity = sslSecurity;
    }

    public ServiceEndpoint clone() {
        try {
            ServiceEndpoint endpoint = (ServiceEndpoint)super.clone();
            endpoint.setSslSecurity(this.sslSecurity);
            return endpoint;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
    }
}

