/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import com.jd.httpservice.agent.HttpServiceConnection;
import com.jd.httpservice.agent.ServiceConnection;
import com.jd.httpservice.agent.ServiceEndpoint;
import java.io.Closeable;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import utils.StringUtils;
import utils.crypto.sm.GmSSLProvider;
import utils.net.SSLMode;
import utils.net.SSLSecurity;

public class ServiceConnectionManager
implements Closeable {
    private static TrustManager trustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] ax509certificate, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] ax509certificate, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };
    private PoolingHttpClientConnectionManager connectionManager;

    public ServiceConnectionManager() {
        this(false, new SSLSecurity());
    }

    public ServiceConnectionManager(boolean secure, SSLSecurity security) {
        SSLMode sslMode = security.getSslMode(true);
        Registry factories = !secure || sslMode.equals((Object)SSLMode.OFF) ? RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)ServiceConnectionManager.createSSLIgnoreConnectionSocketFactory(security)).build() : (sslMode.equals((Object)SSLMode.ONE_WAY) ? RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)ServiceConnectionManager.createOneWaySSLConnectionSocketFactory(security)).build() : RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)ServiceConnectionManager.createTwoWaySSLConnectionSocketFactory(security)).build());
        this.connectionManager = new PoolingHttpClientConnectionManager(factories);
        this.setMaxTotal(100).setDefaultMaxPerRoute(20);
    }

    public static ServiceConnection connect(ServiceEndpoint serviceEndpoint) {
        return new HttpServiceConnection(serviceEndpoint, ServiceConnectionManager.buildHttpClient(serviceEndpoint));
    }

    public static CloseableHttpClient buildHttpClient(ServiceEndpoint serviceEndpoint) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (serviceEndpoint.isSecure()) {
            SSLSecurity sslSecurity = serviceEndpoint.getSslSecurity();
            SSLConnectionSocketFactory csf = null;
            switch (sslSecurity.getSslMode(true)) {
                case OFF: {
                    csf = ServiceConnectionManager.createSSLIgnoreConnectionSocketFactory(sslSecurity);
                    break;
                }
                case ONE_WAY: {
                    csf = ServiceConnectionManager.createOneWaySSLConnectionSocketFactory(sslSecurity);
                    break;
                }
                case TWO_WAY: {
                    csf = ServiceConnectionManager.createTwoWaySSLConnectionSocketFactory(sslSecurity);
                }
            }
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)csf);
        }
        return httpClientBuilder.build();
    }

    private static CloseableHttpClient createHttpClient(ServiceConnectionManager connectionManager) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        HttpClientConnectionManager httpConnMng = connectionManager.getHttpConnectionManager();
        httpClientBuilder.setConnectionManager(httpConnMng).setConnectionManagerShared(true);
        return httpClientBuilder.build();
    }

    private static SSLConnectionSocketFactory createSSLIgnoreConnectionSocketFactory(SSLSecurity security) {
        try {
            if (GmSSLProvider.isGMSSL((String)security.getProtocol())) {
                GmSSLProvider.enableGMSupport((String)security.getProtocol());
            }
            SSLContext context = SSLContext.getInstance(security.getProtocol());
            context.init(null, new TrustManager[]{trustManager}, null);
            return ServiceConnectionManager.createSSLConnectionSocketFactory(context, security);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static SSLConnectionSocketFactory createOneWaySSLConnectionSocketFactory(SSLSecurity security) {
        try {
            if (GmSSLProvider.isGMSSL((String)security.getProtocol())) {
                GmSSLProvider.enableGMSupport((String)security.getProtocol());
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = KeyStore.getInstance(security.getTrustStoreType());
            trustStore.load(new FileInputStream(security.getTrustStore()), security.getTrustStorePassword().toCharArray());
            tmf.init(trustStore);
            TrustManager[] tms = tmf.getTrustManagers();
            SSLContext context = SSLContext.getInstance(security.getProtocol());
            context.init(null, tms, new SecureRandom());
            return ServiceConnectionManager.createSSLConnectionSocketFactory(context, security);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static SSLConnectionSocketFactory createTwoWaySSLConnectionSocketFactory(SSLSecurity security) {
        try {
            if (GmSSLProvider.isGMSSL((String)security.getProtocol())) {
                GmSSLProvider.enableGMSupport((String)security.getProtocol());
            }
            KeyManager[] kms = null;
            if (!StringUtils.isEmpty((String)security.getKeyStore())) {
                KeyStore clientStore = KeyStore.getInstance(security.getKeyStoreType());
                clientStore.load(new FileInputStream(security.getKeyStore()), security.getKeyStorePassword().toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(clientStore, security.getKeyStorePassword().toCharArray());
                kms = kmf.getKeyManagers();
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = KeyStore.getInstance(security.getTrustStoreType());
            trustStore.load(new FileInputStream(security.getTrustStore()), security.getTrustStorePassword().toCharArray());
            tmf.init(trustStore);
            TrustManager[] tms = tmf.getTrustManagers();
            SSLContext context = SSLContext.getInstance(security.getProtocol());
            context.init(kms, tms, new SecureRandom());
            return ServiceConnectionManager.createSSLConnectionSocketFactory(context, security);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static SSLConnectionSocketFactory createSSLConnectionSocketFactory(SSLContext context, SSLSecurity security) {
        Object hostnameVerifier = security.isNoopHostnameVerifier() ? NoopHostnameVerifier.INSTANCE : SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        return new SSLConnectionSocketFactory(context, security.getEnabledProtocols(), security.getCiphers(), (HostnameVerifier)hostnameVerifier);
    }

    public ServiceConnectionManager setMaxTotal(int maxConn) {
        this.connectionManager.setMaxTotal(maxConn);
        return this;
    }

    public ServiceConnectionManager setDefaultMaxPerRoute(int maxConnPerRoute) {
        this.connectionManager.setDefaultMaxPerRoute(maxConnPerRoute);
        return this;
    }

    HttpClientConnectionManager getHttpConnectionManager() {
        return this.connectionManager;
    }

    public ServiceConnection create(ServiceEndpoint serviceEndpoint) {
        CloseableHttpClient httpClient = ServiceConnectionManager.createHttpClient(this);
        return new HttpServiceConnection(serviceEndpoint, httpClient);
    }

    @Override
    public void close() {
        PoolingHttpClientConnectionManager cm = this.connectionManager;
        if (cm != null) {
            this.connectionManager = null;
            cm.close();
        }
    }
}

