/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import com.jd.httpservice.NamedParamMap;
import com.jd.httpservice.agent.RequestUtils;
import com.jd.httpservice.agent.ServiceEndpoint;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import utils.PathUtils;

class RequestPathTemplate {
    private String servicePath;
    private String actionPath;

    public RequestPathTemplate(String servicePath, String actionPath) {
        this.servicePath = PathUtils.standardize((String)servicePath);
        this.actionPath = PathUtils.standardize((String)actionPath);
    }

    private static String updateActionPath(String actionPath, String pathVariableName, String value) {
        String pathVarName = String.format("{%s}", pathVariableName);
        actionPath = actionPath.replace(pathVarName, value);
        return actionPath;
    }

    public URI generateRequestURI(ServiceEndpoint serviceEndpoint, Map<String, String> pathParams, NamedParamMap queryParams, Charset encodingCharset) {
        String reallyActionPath = this.createActionPath(pathParams);
        String path = PathUtils.concatPaths((String[])new String[]{serviceEndpoint.getContextPath(), this.servicePath, reallyActionPath});
        path = PathUtils.absolute((String)path);
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setCharset(encodingCharset);
        if (serviceEndpoint.isSecure()) {
            uriBuilder.setScheme("https");
        } else {
            uriBuilder.setScheme("http");
        }
        uriBuilder.setHost(serviceEndpoint.getHost());
        uriBuilder.setPort(serviceEndpoint.getPort());
        uriBuilder.setPath(path.toString());
        List<NameValuePair> queryParameters = RequestUtils.createQueryParameters(queryParams);
        uriBuilder.setParameters(queryParameters);
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String createActionPath(Map<String, String> pathParams) {
        String reallyActionPath = this.actionPath;
        if (pathParams != null) {
            for (Map.Entry<String, String> pathParam : pathParams.entrySet()) {
                reallyActionPath = RequestPathTemplate.updateActionPath(reallyActionPath, pathParam.getKey(), pathParam.getValue());
            }
        }
        return reallyActionPath;
    }
}

