/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import com.jd.httpservice.HttpServiceException;
import com.jd.httpservice.NamedParamMap;
import com.jd.httpservice.agent.ArgDefEntry;
import com.jd.httpservice.agent.RequestParamDefinition;
import com.jd.httpservice.agent.RequestParamMapDefinition;
import com.jd.httpservice.agent.RequestParamResolver;
import java.util.LinkedList;
import java.util.List;
import org.springframework.util.CollectionUtils;

abstract class RequestParamResolvers {
    public static final RequestParamResolver NONE_REQUEST_PARAM_RESOLVER = new NoneRequestParamResolver();

    RequestParamResolvers() {
    }

    public static RequestParamResolver createParamMapResolver(List<ArgDefEntry<RequestParamDefinition>> reqParamDefinitions, List<ArgDefEntry<RequestParamMapDefinition>> reqParamMapDefinitions) {
        if (!CollectionUtils.isEmpty(reqParamDefinitions) && !CollectionUtils.isEmpty(reqParamMapDefinitions)) {
            RequestParamResolver resolver1 = RequestParamResolvers.createParamResolver(reqParamDefinitions);
            RequestParamResolver resolver2 = RequestParamResolvers.createParamMapResolver(reqParamMapDefinitions);
            return new MultiRequestParamResolverWrapper(resolver1, resolver2);
        }
        if (!CollectionUtils.isEmpty(reqParamDefinitions)) {
            return RequestParamResolvers.createParamResolver(reqParamDefinitions);
        }
        if (!CollectionUtils.isEmpty(reqParamMapDefinitions)) {
            return RequestParamResolvers.createParamMapResolver(reqParamMapDefinitions);
        }
        return NONE_REQUEST_PARAM_RESOLVER;
    }

    public static RequestParamResolver createParamMapResolver(List<ArgDefEntry<RequestParamMapDefinition>> definitions) {
        return new ArgArrayRequestParamMapResolver(definitions);
    }

    public static RequestParamResolver createParamResolver(List<ArgDefEntry<RequestParamDefinition>> definitions) {
        return new ArgArrayRequestParamResolver(definitions);
    }

    private static class NoneRequestParamResolver
    implements RequestParamResolver {
        private NoneRequestParamResolver() {
        }

        @Override
        public NamedParamMap resolve(Object[] args) {
            return new NamedParamMap();
        }
    }

    private static class MultiRequestParamResolverWrapper
    implements RequestParamResolver {
        private RequestParamResolver[] resolvers;

        public MultiRequestParamResolverWrapper(RequestParamResolver ... resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public NamedParamMap resolve(Object[] args) {
            NamedParamMap params = new NamedParamMap();
            for (RequestParamResolver resolver : this.resolvers) {
                NamedParamMap extParams = resolver.resolve(args);
                params.merge(extParams);
            }
            return params;
        }
    }

    private static class ArgArrayRequestParamResolver
    implements RequestParamResolver {
        private List<ArgDefEntry<RequestParamDefinition>> paramDefinitions;

        public ArgArrayRequestParamResolver(List<ArgDefEntry<RequestParamDefinition>> paramDefinitions) {
            this.paramDefinitions = new LinkedList<ArgDefEntry<RequestParamDefinition>>(paramDefinitions);
        }

        @Override
        public NamedParamMap resolve(Object[] args) {
            NamedParamMap params = new NamedParamMap();
            for (ArgDefEntry<RequestParamDefinition> defEntry : this.paramDefinitions) {
                RequestParamDefinition def = defEntry.getDefinition();
                Object arg = args[defEntry.getIndex()];
                if (arg == null && def.isRequired()) {
                    throw new HttpServiceException("The required argument object is null!");
                }
                this.resovleParams(params, def, arg);
            }
            return params;
        }

        private void resovleParams(NamedParamMap params, RequestParamDefinition def, Object arg) {
            if (def.isArray() && arg != null) {
                if (arg.getClass().isArray()) {
                    Object[] valObjs;
                    for (Object val : valObjs = (Object[])arg) {
                        this.resovleParamValue(params, def, val);
                    }
                }
            } else {
                this.resovleParamValue(params, def, arg);
            }
        }

        private void resovleParamValue(NamedParamMap params, RequestParamDefinition def, Object arg) {
            String value = def.getConverter().toString(arg);
            if (value == null) {
                if (def.isRequired()) {
                    throw new HttpServiceException("The required argument value is null!");
                }
                return;
            }
            if (value.equals(def.getIgnoreValue())) {
                return;
            }
            params.addParam(def.getName(), value);
        }
    }

    private static class ArgArrayRequestParamMapResolver
    implements RequestParamResolver {
        private List<ArgDefEntry<RequestParamMapDefinition>> definitions;

        public ArgArrayRequestParamMapResolver(List<ArgDefEntry<RequestParamMapDefinition>> definitions) {
            this.definitions = new LinkedList<ArgDefEntry<RequestParamMapDefinition>>(definitions);
        }

        @Override
        public NamedParamMap resolve(Object[] args) {
            NamedParamMap params = new NamedParamMap();
            for (ArgDefEntry<RequestParamMapDefinition> defEntry : this.definitions) {
                RequestParamMapDefinition def = defEntry.getDefinition();
                Object argValue = args[defEntry.getIndex()];
                if (argValue == null && def.isRequired()) {
                    throw new HttpServiceException("The required argument object is null!");
                }
                NamedParamMap extParams = def.getConverter().toProperties(argValue);
                if (extParams.isEmpty()) {
                    if (!def.isRequired()) continue;
                    throw new HttpServiceException("The required request parameter map is empty!");
                }
                if (extParams == null) continue;
                params.merge(extParams, def.getPrefix());
            }
            return params;
        }
    }
}

