/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import com.jd.httpservice.PropertiesConverter;
import com.jd.httpservice.RequestParamMap;
import com.jd.httpservice.agent.ArgDefEntry;
import com.jd.httpservice.agent.PropertiesConverterFactory;
import java.util.LinkedList;
import java.util.List;
import org.springframework.util.StringUtils;

class RequestParamMapDefinition {
    private String prefix;
    private boolean required;
    private PropertiesConverter converter;

    public RequestParamMapDefinition(String prefix, String seperator, boolean required, PropertiesConverter converter) {
        this.prefix = prefix == null || prefix.length() == 0 ? "" : prefix + seperator;
        this.required = required;
        this.converter = converter;
    }

    public boolean isRequired() {
        return this.required;
    }

    public PropertiesConverter getConverter() {
        return this.converter;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static List<ArgDefEntry<RequestParamMapDefinition>> resolveParamMapDefinitions(List<ArgDefEntry<RequestParamMap>> reqParamAnnos) {
        LinkedList<ArgDefEntry<RequestParamMapDefinition>> reqDefs = new LinkedList<ArgDefEntry<RequestParamMapDefinition>>();
        for (ArgDefEntry<RequestParamMap> entry : reqParamAnnos) {
            RequestParamMap reqParamAnno = entry.getDefinition();
            String prefix = StringUtils.trimWhitespace((String)reqParamAnno.prefix());
            String seperator = StringUtils.trimWhitespace((String)reqParamAnno.seperator());
            Class<?> converterClazz = reqParamAnno.converter();
            PropertiesConverter converter = PropertiesConverterFactory.instantiatePropertiesConverter(converterClazz, entry.getArgType());
            RequestParamMapDefinition reqDef = new RequestParamMapDefinition(prefix, seperator, reqParamAnno.required(), converter);
            reqDefs.add(new ArgDefEntry<RequestParamMapDefinition>(entry.getIndex(), entry.getArgType(), reqDef));
        }
        return reqDefs;
    }
}

