/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import com.jd.httpservice.RequestParam;
import com.jd.httpservice.StringConverter;
import com.jd.httpservice.agent.ArgDefEntry;
import com.jd.httpservice.agent.IllegalHttpServiceDefinitionException;
import com.jd.httpservice.agent.StringConverterFactory;
import java.util.LinkedList;
import java.util.List;
import org.springframework.util.StringUtils;

class RequestParamDefinition {
    private String name;
    private boolean required;
    private boolean array;
    private String ignoreValue;
    private StringConverter converter;

    public RequestParamDefinition(String name, boolean required, boolean array, String ignoreValue, StringConverter converter) {
        this.name = name;
        this.required = required;
        this.array = array;
        this.ignoreValue = ignoreValue;
        this.converter = converter;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isArray() {
        return this.array;
    }

    public String getIgnoreValue() {
        return this.ignoreValue;
    }

    public StringConverter getConverter() {
        return this.converter;
    }

    public static List<ArgDefEntry<RequestParamDefinition>> resolveSingleParamDefinitions(List<ArgDefEntry<RequestParam>> reqParamAnnos) {
        LinkedList<ArgDefEntry<RequestParamDefinition>> reqDefs = new LinkedList<ArgDefEntry<RequestParamDefinition>>();
        for (ArgDefEntry<RequestParam> entry : reqParamAnnos) {
            RequestParam reqParamAnno = entry.getDefinition();
            RequestParamDefinition reqDef = RequestParamDefinition.resolveDefinition(reqParamAnno);
            reqDefs.add(new ArgDefEntry<RequestParamDefinition>(entry.getIndex(), entry.getArgType(), reqDef));
        }
        return reqDefs;
    }

    public static RequestParamDefinition resolveDefinition(RequestParam reqParamAnno) {
        if (StringUtils.isEmpty((Object)reqParamAnno.name())) {
            throw new IllegalHttpServiceDefinitionException("The name of request parameter is empty!");
        }
        Class<?> converterClazz = reqParamAnno.converter();
        StringConverter converter = StringConverterFactory.instantiateStringConverter(converterClazz);
        RequestParamDefinition reqDef = new RequestParamDefinition(reqParamAnno.name(), reqParamAnno.required(), reqParamAnno.array(), reqParamAnno.ignoreValue(), converter);
        return reqDef;
    }
}

