/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import com.jd.httpservice.HttpServiceException;
import com.jd.httpservice.agent.ArgDefEntry;
import com.jd.httpservice.agent.RequestBodyDefinition;
import com.jd.httpservice.agent.RequestBodyResolver;
import java.io.IOException;
import java.io.OutputStream;
import utils.io.RuntimeIOException;

class RequestBodyResolvers {
    public static final RequestBodyResolver NULL_BODY_RESOLVER = new NullBodyResolver();

    RequestBodyResolvers() {
    }

    public static RequestBodyResolver createArgumentResolver(ArgDefEntry<RequestBodyDefinition> defEntry) {
        return new ArgurmentResolver(defEntry);
    }

    private static final class NullBodyResolver
    implements RequestBodyResolver {
        private NullBodyResolver() {
        }

        @Override
        public void resolve(Object[] args, OutputStream out) {
        }
    }

    private static final class ArgurmentResolver
    implements RequestBodyResolver {
        private ArgDefEntry<RequestBodyDefinition> defEntry;

        public ArgurmentResolver(ArgDefEntry<RequestBodyDefinition> defEntry) {
            this.defEntry = defEntry;
        }

        @Override
        public void resolve(Object[] args, OutputStream out) {
            Object arg = args[this.defEntry.getIndex()];
            if (arg == null && this.defEntry.getDefinition().isRequired()) {
                throw new HttpServiceException("The required body argument is null!");
            }
            try {
                this.defEntry.getDefinition().getConverter().write(arg, out);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

