/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import com.jd.httpservice.NamedParamMap;
import com.jd.httpservice.PropertiesConverter;
import com.jd.httpservice.RequestParam;
import com.jd.httpservice.agent.ArgDefEntry;
import com.jd.httpservice.agent.RequestParamDefinition;
import com.jd.httpservice.agent.RequestParamResolver;
import com.jd.httpservice.agent.RequestParamResolvers;
import java.beans.PropertyDescriptor;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.convert.TypeDescriptor;

public class PojoPropertiesConverter
implements PropertiesConverter {
    private List<String> propNames = new LinkedList<String>();
    private RequestParamResolver paramResolver;
    private Class<?> argType;

    public PojoPropertiesConverter(Class<?> argType) {
        this.argType = argType;
        this.resolveParamProperties();
    }

    private void resolveParamProperties() {
        PropertyDescriptor[] propDescs;
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(this.argType);
        LinkedList<ArgDefEntry<RequestParamDefinition>> reqParamDefs = new LinkedList<ArgDefEntry<RequestParamDefinition>>();
        for (PropertyDescriptor propDesc : propDescs = beanWrapper.getPropertyDescriptors()) {
            TypeDescriptor propTypeDesc = beanWrapper.getPropertyTypeDescriptor(propDesc.getName());
            RequestParam reqParamAnno = (RequestParam)propTypeDesc.getAnnotation(RequestParam.class);
            if (reqParamAnno == null) continue;
            RequestParamDefinition reqParamDef = RequestParamDefinition.resolveDefinition(reqParamAnno);
            ArgDefEntry<RequestParamDefinition> defEntry = new ArgDefEntry<RequestParamDefinition>(reqParamDefs.size(), propTypeDesc.getType(), reqParamDef);
            reqParamDefs.add(defEntry);
            this.propNames.add(propDesc.getName());
        }
        this.paramResolver = RequestParamResolvers.createParamResolver(reqParamDefs);
    }

    @Override
    public NamedParamMap toProperties(Object arg) {
        if (this.propNames.size() == 0) {
            return new NamedParamMap();
        }
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(arg);
        Object[] propValues = new Object[this.propNames.size()];
        int i = 0;
        for (String propName : this.propNames) {
            propValues[i] = beanWrapper.getPropertyValue(propName);
            ++i;
        }
        NamedParamMap params = this.paramResolver.resolve(propValues);
        return params;
    }
}

