/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import com.jd.httpservice.agent.ArgDefEntry;
import com.jd.httpservice.agent.PathParamDefinition;
import com.jd.httpservice.agent.PathParamResolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PathParamResolvers {
    public static final PathParamResolver NONE_PATH_PARAM_RESOLVER = new NonePathParamResolver();

    PathParamResolvers() {
    }

    public static PathParamResolver createResolver(List<ArgDefEntry<PathParamDefinition>> paramDefinitions) {
        return new ArgArrayPathParamResolver(paramDefinitions);
    }

    private static class NonePathParamResolver
    implements PathParamResolver {
        private NonePathParamResolver() {
        }

        @Override
        public Map<String, String> resolve(Object[] args) {
            return Collections.EMPTY_MAP;
        }
    }

    private static class ArgArrayPathParamResolver
    implements PathParamResolver {
        private List<ArgDefEntry<PathParamDefinition>> paramDefinitions;

        public ArgArrayPathParamResolver(List<ArgDefEntry<PathParamDefinition>> paramDefinitions) {
            this.paramDefinitions = paramDefinitions;
        }

        @Override
        public Map<String, String> resolve(Object[] args) {
            HashMap<String, String> pathParams = new HashMap<String, String>();
            for (ArgDefEntry<PathParamDefinition> paramDef : this.paramDefinitions) {
                String name = paramDef.getDefinition().getName();
                String value = paramDef.getDefinition().getConverter().toString(args[paramDef.getIndex()]);
                pathParams.put(name, value);
            }
            return pathParams;
        }
    }
}

