/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import com.jd.httpservice.agent.ServiceConnection;
import com.jd.httpservice.agent.ServiceEndpoint;
import java.io.IOException;
import org.apache.http.impl.client.CloseableHttpClient;

class HttpServiceConnection
implements ServiceConnection {
    private ServiceEndpoint endpoint;
    private CloseableHttpClient httpClient;

    HttpServiceConnection(ServiceEndpoint endpoint, CloseableHttpClient httpClient) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
    }

    CloseableHttpClient getHttpClient() {
        CloseableHttpClient cli = this.httpClient;
        if (cli == null) {
            throw new IllegalArgumentException("HttpServiceConnection has been closed!");
        }
        return cli;
    }

    @Override
    public void close() {
        CloseableHttpClient cli = this.httpClient;
        if (cli != null) {
            this.httpClient = null;
            try {
                cli.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    @Override
    public ServiceEndpoint getEndpoint() {
        return this.endpoint;
    }
}

