/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import com.jd.httpservice.HttpAction;
import com.jd.httpservice.HttpMethod;
import com.jd.httpservice.HttpService;
import com.jd.httpservice.HttpServiceContext;
import com.jd.httpservice.HttpServiceException;
import com.jd.httpservice.HttpStatusException;
import com.jd.httpservice.NamedParam;
import com.jd.httpservice.NamedParamMap;
import com.jd.httpservice.PathParam;
import com.jd.httpservice.RequestBody;
import com.jd.httpservice.RequestBodyConverter;
import com.jd.httpservice.RequestParam;
import com.jd.httpservice.RequestParamFilter;
import com.jd.httpservice.RequestParamMap;
import com.jd.httpservice.ResponseBodyConverterFactory;
import com.jd.httpservice.ResponseConverter;
import com.jd.httpservice.StringConverter;
import com.jd.httpservice.agent.ArgDefEntry;
import com.jd.httpservice.agent.AuthorizationHeader;
import com.jd.httpservice.agent.AuthorizationHeaderResovler;
import com.jd.httpservice.agent.DefaultResponseConverterFactory;
import com.jd.httpservice.agent.HttpServiceConnection;
import com.jd.httpservice.agent.HttpServiceProxy;
import com.jd.httpservice.agent.IllegalHttpServiceDefinitionException;
import com.jd.httpservice.agent.LocalHttpDelete;
import com.jd.httpservice.agent.NullRequestParamFilter;
import com.jd.httpservice.agent.PathParamDefinition;
import com.jd.httpservice.agent.PathParamResolver;
import com.jd.httpservice.agent.PathParamResolvers;
import com.jd.httpservice.agent.RequestBodyDefinition;
import com.jd.httpservice.agent.RequestBodyResolver;
import com.jd.httpservice.agent.RequestBodyResolverComposite;
import com.jd.httpservice.agent.RequestBodyResolvers;
import com.jd.httpservice.agent.RequestHeader;
import com.jd.httpservice.agent.RequestParamDefinition;
import com.jd.httpservice.agent.RequestParamMapDefinition;
import com.jd.httpservice.agent.RequestParamResolver;
import com.jd.httpservice.agent.RequestParamResolvers;
import com.jd.httpservice.agent.RequestPathTemplate;
import com.jd.httpservice.agent.ServiceActionContext;
import com.jd.httpservice.agent.ServiceConnection;
import com.jd.httpservice.agent.ServiceConnectionManager;
import com.jd.httpservice.agent.ServiceEndpoint;
import com.jd.httpservice.agent.ServiceRequest;
import com.jd.httpservice.agent.StringConverterFactory;
import com.jd.httpservice.agent.TypeAutoAdaptingRequestBodyConverter;
import com.jd.httpservice.converters.NullResponseConverter;
import com.jd.httpservice.converters.StringResponseConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class HttpServiceAgent {
    private static final NamedParam[] EMPTY_PARAMS = new NamedParam[0];
    private static Map<Class<?>, HttpServiceAgent> serviceAgentMap = new ConcurrentHashMap();
    private Class<?> serviceClass;
    private RequestBodyConverter defaultRequestBodyConverter;
    private ResponseConverter defaultResponseConverter;
    private ResponseBodyConverterFactory responseConverterFactory;
    private AuthorizationHeaderResovler authorizationHeaderResolver;
    private Map<Method, ServiceActionContext> actions = new HashMap<Method, ServiceActionContext>();

    private HttpServiceAgent(Class<?> serviceClass, AuthorizationHeaderResovler authResolver) {
        this.serviceClass = serviceClass;
        this.authorizationHeaderResolver = authResolver;
        this.resolveService();
    }

    public static <T> T createService(Class<T> serviceClass, ServiceEndpoint serviceEndpoint, RequestHeader ... authorizationHeaders) {
        return HttpServiceAgent.createService(serviceClass, serviceEndpoint, null, null, authorizationHeaders);
    }

    public static <T> T createService(Class<T> serviceClass, ServiceEndpoint serviceEndpoint) {
        return HttpServiceAgent.createService(serviceClass, serviceEndpoint, (AuthorizationHeaderResovler)null);
    }

    public static <T> T createService(Class<T> serviceClass, ServiceEndpoint serviceEndpoint, AuthorizationHeaderResovler authorizationHeaderResolver) {
        return HttpServiceAgent.createService(serviceClass, serviceEndpoint, null, authorizationHeaderResolver, new RequestHeader[0]);
    }

    public static <T> T createService(Class<T> serviceClass, ServiceEndpoint serviceEndpoint, ServiceConnectionManager connectionManager, AuthorizationHeaderResovler authorizationHeaderResolver, RequestHeader ... headers) {
        ServiceConnection connection = null;
        connection = connectionManager == null ? ServiceConnectionManager.connect(serviceEndpoint) : connectionManager.create(serviceEndpoint);
        return HttpServiceAgent.createService(serviceClass, connection, authorizationHeaderResolver, headers);
    }

    public static <T> T createService(Class<T> serviceClass, ServiceConnection connection, AuthorizationHeaderResovler authorizationHeaderResolver, RequestHeader ... headers) {
        return HttpServiceAgent.createService(serviceClass, connection, authorizationHeaderResolver, headers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T createService(Class<T> serviceClass, ServiceConnection connection, AuthorizationHeaderResovler authorizationHeaderResolver, RequestHeader[] headers, Object bindingData) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("Service class is null!");
        }
        if (!(connection instanceof HttpServiceConnection)) {
            throw new IllegalArgumentException("Illegal service connection! It must be created by the ServiceConnectionManager!");
        }
        HttpServiceConnection httpConnection = (HttpServiceConnection)connection;
        HttpServiceAgent agent = serviceAgentMap.get(serviceClass);
        if (agent == null) {
            Class<T> clazz = serviceClass;
            synchronized (clazz) {
                agent = serviceAgentMap.get(serviceClass);
                if (agent == null) {
                    agent = new HttpServiceAgent(serviceClass, authorizationHeaderResolver);
                    serviceAgentMap.put(serviceClass, agent);
                }
            }
        }
        ServiceInvocationHandler invocationHandler = new ServiceInvocationHandler(agent, httpConnection, headers, bindingData);
        Object serviceProxy = Proxy.newProxyInstance(serviceClass.getClassLoader(), new Class[]{HttpServiceProxy.class, serviceClass}, (InvocationHandler)invocationHandler);
        return (T)serviceProxy;
    }

    private void resolveService() {
        Method[] mths;
        Class<?> responseConverterFactoryClazz;
        Class<?> defaultResponseConverterClazz;
        HttpService serviceAnno = this.serviceClass.getAnnotation(HttpService.class);
        if (serviceAnno == null) {
            throw new IllegalHttpServiceDefinitionException("The specific service was not tag with HttpService annotation!");
        }
        String servicePath = serviceAnno.path();
        if (StringUtils.isEmpty((Object)(servicePath = StringUtils.cleanPath((String)servicePath)))) {
            throw new IllegalHttpServiceDefinitionException("Illegal path or no path was specified for the HttpService!-- path=" + serviceAnno.path());
        }
        Class<?> defaultRequestBodyConverterClazz = serviceAnno.defaultRequestBodyConverter();
        if (defaultRequestBodyConverterClazz != null && defaultRequestBodyConverterClazz != RequestBodyConverter.class) {
            if (RequestBodyConverter.class.isAssignableFrom(defaultRequestBodyConverterClazz)) {
                this.defaultRequestBodyConverter = (RequestBodyConverter)BeanUtils.instantiate(defaultRequestBodyConverterClazz);
            } else {
                throw new IllegalHttpServiceDefinitionException("The specified default request body converter of service doesn't implement the interface " + RequestBodyConverter.class.getName() + "!");
            }
        }
        if ((defaultResponseConverterClazz = serviceAnno.defaultResponseConverter()) != null && defaultResponseConverterClazz != ResponseConverter.class) {
            if (ResponseConverter.class.isAssignableFrom(defaultResponseConverterClazz)) {
                this.defaultResponseConverter = (ResponseConverter)BeanUtils.instantiate(defaultResponseConverterClazz);
            } else {
                throw new IllegalHttpServiceDefinitionException("The specified default response converter of service doesn't implement the interface " + ResponseConverter.class.getName() + "!");
            }
        }
        if ((responseConverterFactoryClazz = serviceAnno.responseConverterFactory()) != null && responseConverterFactoryClazz != ResponseBodyConverterFactory.class) {
            if (ResponseBodyConverterFactory.class.isAssignableFrom(responseConverterFactoryClazz)) {
                this.responseConverterFactory = (ResponseBodyConverterFactory)BeanUtils.instantiate(responseConverterFactoryClazz);
            } else {
                throw new IllegalHttpServiceDefinitionException("The specified response converter factory of service doesn't implement the interface " + ResponseBodyConverterFactory.class.getName() + "!");
            }
        }
        for (Method mth : mths = this.serviceClass.getMethods()) {
            ServiceActionContext actionContext = this.resolveAction(mth, servicePath);
            if (actionContext == null) continue;
            this.actions.put(mth, actionContext);
        }
    }

    private ServiceActionContext resolveAction(Method mth, String servicePath) {
        HttpAction actionAnno = mth.getAnnotation(HttpAction.class);
        if (actionAnno == null) {
            return null;
        }
        String actionPath = StringUtils.cleanPath((String)actionAnno.path());
        if (StringUtils.isEmpty((Object)actionPath)) {
            actionPath = mth.getName();
        }
        RequestPathTemplate pathTemplate = new RequestPathTemplate(servicePath, actionPath);
        if (actionAnno.method() == null) {
            throw new IllegalHttpServiceDefinitionException("The http method of action was not specified!");
        }
        String contentType = actionAnno.contentType();
        if (contentType != null && (contentType = contentType.trim()).length() == 0) {
            contentType = null;
        }
        RequestParamFilter reqParamFilter = this.createRequestParamFilter(actionAnno);
        ResponseConverter responseConverter = this.createResponseConverter(actionAnno, mth);
        RequestBodyResolverComposite bodyResolverComposite = new RequestBodyResolverComposite();
        Class<?>[] paramTypes = mth.getParameterTypes();
        Annotation[][] paramAnnos = mth.getParameterAnnotations();
        LinkedList<ArgDefEntry<RequestParam>> reqParamAnnos = new LinkedList<ArgDefEntry<RequestParam>>();
        LinkedList<ArgDefEntry<RequestParamMap>> reqParamMapAnnos = new LinkedList<ArgDefEntry<RequestParamMap>>();
        LinkedList<ArgDefEntry<PathParam>> pathParamAnnos = new LinkedList<ArgDefEntry<PathParam>>();
        for (int i = 0; i < paramTypes.length; ++i) {
            PathParam pathParamAnno;
            RequestParamMap reqParamsAnno;
            RequestParam reqParamAnno;
            RequestBody reqBodyAnno = HttpServiceAgent.findAnnotation(RequestBody.class, paramAnnos[i]);
            if (HttpServiceAgent.hasConflictiveAnnotation(reqBodyAnno, reqParamAnno = HttpServiceAgent.findAnnotation(RequestParam.class, paramAnnos[i]), reqParamsAnno = HttpServiceAgent.findAnnotation(RequestParamMap.class, paramAnnos[i]), pathParamAnno = HttpServiceAgent.findAnnotation(PathParam.class, paramAnnos[i]))) {
                throw new IllegalHttpServiceDefinitionException("The argument[" + i + "] of action has conflictive definition!");
            }
            if (reqBodyAnno != null) {
                RequestBodyResolver reqBodyResolver = this.createBodyResolver(new ArgDefEntry<RequestBody>(i, paramTypes[i], reqBodyAnno));
                bodyResolverComposite.addRequestBodyResolver(reqBodyResolver);
            }
            if (reqParamAnno != null) {
                reqParamAnnos.add(new ArgDefEntry<RequestParam>(i, paramTypes[i], reqParamAnno));
            }
            if (reqParamsAnno != null) {
                reqParamMapAnnos.add(new ArgDefEntry<RequestParamMap>(i, paramTypes[i], reqParamsAnno));
            }
            if (pathParamAnno == null) continue;
            pathParamAnnos.add(new ArgDefEntry<PathParam>(i, paramTypes[i], pathParamAnno));
        }
        RequestParamResolver reqParamResolver = this.createRequestParamResolver(reqParamAnnos, reqParamMapAnnos);
        PathParamResolver pathParamResolver = this.createPathParamResolver(pathParamAnnos);
        Class<?>[] thrownExceptionTypes = mth.getExceptionTypes();
        ServiceActionContext actionContext = new ServiceActionContext(mth, actionAnno.method(), contentType, pathTemplate, pathParamResolver, reqParamFilter, reqParamResolver, bodyResolverComposite, responseConverter, thrownExceptionTypes, actionAnno.resolveContentOnHttpError());
        return actionContext;
    }

    private static <T> T findAnnotation(Class<T> clazz, Annotation[] annos) {
        for (Annotation annotation : annos) {
            if (!clazz.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    private RequestParamFilter createRequestParamFilter(HttpAction actionDef) {
        Class<?> reqParamFilterClass = actionDef.requestParamFilter();
        if (reqParamFilterClass == null || reqParamFilterClass == RequestParamFilter.class) {
            return NullRequestParamFilter.INSTANCE;
        }
        if (RequestParamFilter.class.isAssignableFrom(reqParamFilterClass)) {
            return (RequestParamFilter)BeanUtils.instantiate(reqParamFilterClass);
        }
        throw new IllegalHttpServiceDefinitionException("The specified RequestParamFilter doesn't implement the interface " + RequestParamFilter.class.getName() + "!");
    }

    private ResponseConverter createResponseConverter(HttpAction actionDef, Method mth) {
        Class<?> retnClazz = mth.getReturnType();
        if (Void.class.equals(retnClazz)) {
            return NullResponseConverter.INSTANCE;
        }
        Class<?> respConverterClass = actionDef.responseConverter();
        if (respConverterClass == null || respConverterClass == ResponseConverter.class) {
            if (this.defaultResponseConverter != null) {
                return this.defaultResponseConverter;
            }
            if (this.responseConverterFactory != null) {
                return this.responseConverterFactory.createResponseConverter(actionDef, mth);
            }
        }
        if (respConverterClass != null && respConverterClass != ResponseConverter.class) {
            if (ResponseConverter.class.isAssignableFrom(respConverterClass)) {
                return (ResponseConverter)BeanUtils.instantiate(respConverterClass);
            }
            throw new IllegalHttpServiceDefinitionException("The specified response converter doesn't implement the interface " + ResponseConverter.class.getName() + "!");
        }
        return DefaultResponseConverterFactory.INSTANCE.createResponseConverter(actionDef, mth);
    }

    private PathParamResolver createPathParamResolver(List<ArgDefEntry<PathParam>> pathParamAnnos) {
        if (pathParamAnnos.size() == 0) {
            return PathParamResolvers.NONE_PATH_PARAM_RESOLVER;
        }
        LinkedList<ArgDefEntry<PathParamDefinition>> pathParamDefs = new LinkedList<ArgDefEntry<PathParamDefinition>>();
        for (ArgDefEntry<PathParam> entry : pathParamAnnos) {
            if (StringUtils.isEmpty((Object)entry.getDefinition().name())) {
                throw new IllegalHttpServiceDefinitionException("The name of path parameter is empty!");
            }
            Class<?> converterClazz = entry.getDefinition().converter();
            StringConverter converter = StringConverterFactory.instantiateStringConverter(converterClazz);
            ArgDefEntry<PathParamDefinition> argDefEntry = new ArgDefEntry<PathParamDefinition>(entry.getIndex(), entry.getArgType(), new PathParamDefinition(entry.getDefinition().name(), converter));
            pathParamDefs.add(argDefEntry);
        }
        return PathParamResolvers.createResolver(pathParamDefs);
    }

    private RequestParamResolver createRequestParamResolver(List<ArgDefEntry<RequestParam>> reqParamAnnos, List<ArgDefEntry<RequestParamMap>> reqParamsAnnos) {
        List<ArgDefEntry<RequestParamDefinition>> reqDefs = RequestParamDefinition.resolveSingleParamDefinitions(reqParamAnnos);
        List<ArgDefEntry<RequestParamMapDefinition>> reqMapDefs = RequestParamMapDefinition.resolveParamMapDefinitions(reqParamsAnnos);
        return RequestParamResolvers.createParamMapResolver(reqDefs, reqMapDefs);
    }

    private RequestBodyResolver createBodyResolver(ArgDefEntry<RequestBody> reqBodyAnnoEntry) {
        Class<?> converterClazz = reqBodyAnnoEntry.getDefinition().converter();
        RequestBodyConverter converter = null;
        if (converterClazz == RequestBodyConverter.class || converterClazz == null) {
            converter = this.defaultRequestBodyConverter;
            if (converter == null) {
                converter = new TypeAutoAdaptingRequestBodyConverter(reqBodyAnnoEntry.getArgType());
            }
        } else {
            if (!ClassUtils.isAssignable(RequestBodyConverter.class, converterClazz)) {
                throw new IllegalHttpServiceDefinitionException("The specified body converter doesn't implement the interface " + RequestBodyConverter.class.getName() + "!");
            }
            converter = (RequestBodyConverter)BeanUtils.instantiate(converterClazz);
        }
        RequestBodyDefinition reqBodyDef = new RequestBodyDefinition(reqBodyAnnoEntry.getDefinition().required(), converter);
        ArgDefEntry<RequestBodyDefinition> reqBodyDefEntry = new ArgDefEntry<RequestBodyDefinition>(reqBodyAnnoEntry.getIndex(), reqBodyAnnoEntry.getArgType(), reqBodyDef);
        return RequestBodyResolvers.createArgumentResolver(reqBodyDefEntry);
    }

    private static boolean hasConflictiveAnnotation(RequestBody reqBodyAnno, RequestParam reqParamAnno, RequestParamMap reqParamsAnno, PathParam pathParamAnno) {
        return 1 < (reqBodyAnno == null ? 0 : 1) + (reqParamAnno == null ? 0 : 1) + (reqParamsAnno == null ? 0 : 1) + (pathParamAnno == null ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invoke(ServiceEndpoint serviceEndpoint, HttpServiceContext serviceContext, CloseableHttpClient httpClient, RequestHeader[] headers, Method method, Object[] args) throws Throwable {
        ServiceActionContext actionContext = this.actions.get(method);
        if (actionContext == null) {
            throw new UnsupportedOperationException("The invoked method was not a service action!");
        }
        try {
            Header[] contentTypeHeaders;
            HttpServiceRequest request = this.resolveRequest(serviceEndpoint, actionContext, args);
            HttpUriRequest httpRequest = this.buildRequest(request);
            this.setHeaders(httpRequest, headers);
            this.setHeaders(httpRequest, request.getHeaders());
            if (this.authorizationHeaderResolver != null) {
                AuthorizationHeader auth = this.authorizationHeaderResolver.generateHeader(request);
                this.buildAuthorization(httpRequest, auth);
            }
            if ((contentTypeHeaders = httpRequest.getHeaders("Content-Type")) == null || contentTypeHeaders.length == 0) {
                httpRequest.setHeader("Content-Type", "application/json");
            }
            try (CloseableHttpResponse response = httpClient.execute(httpRequest);){
                Object respObject;
                if (response.getStatusLine().getStatusCode() >= 400) {
                    this.processAndThrowHttpException(actionContext, request, response);
                    Object var12_13 = null;
                    return var12_13;
                }
                InputStream respStream = response.getEntity().getContent();
                Object object = respObject = actionContext.getResponseConverter().getResponse(request, respStream, serviceContext);
                return object;
            }
        }
        catch (Exception e) {
            if (this.isCustomThownException(e, actionContext)) {
                throw e;
            }
            if (!(e instanceof HttpServiceException)) throw new HttpServiceException(e.getMessage(), e);
            throw (HttpServiceException)e;
        }
    }

    private void setHeaders(HttpUriRequest httpRequest, RequestHeader[] headers) {
        if (headers == null) {
            return;
        }
        for (RequestHeader header : headers) {
            httpRequest.setHeader(header.getName(), header.getValue());
        }
    }

    private void setHeaders(HttpUriRequest httpRequest, Properties customHeaders) {
        Set<String> names = customHeaders.stringPropertyNames();
        for (String name : names) {
            httpRequest.setHeader(name, customHeaders.getProperty(name));
        }
    }

    private boolean isCustomThownException(Exception e, ServiceActionContext actionContext) {
        Class<?>[] thrownExTypes;
        Class<?> exType = e.getClass();
        for (Class<?> thrExType : thrownExTypes = actionContext.getThrownExceptionTypes()) {
            if (!thrExType.isAssignableFrom(exType)) continue;
            return true;
        }
        return false;
    }

    private void processAndThrowHttpException(ServiceActionContext actionContext, ServiceRequest request, CloseableHttpResponse response) throws HttpStatusException {
        String content = null;
        if (actionContext.isResolveContentOnHttpError()) {
            try {
                InputStream respStream = response.getEntity().getContent();
                content = (String)StringResponseConverter.INSTANCE.getResponse(request, respStream, null);
            }
            catch (UnsupportedOperationException e) {
                throw new HttpServiceException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new HttpServiceException(e.getMessage(), e);
            }
            catch (Exception e) {
                if (e instanceof HttpServiceException) {
                    throw (HttpServiceException)e;
                }
                throw new HttpServiceException(e.getMessage(), e);
            }
        }
        String errMsg = String.format("[status=%s] %s", response.getStatusLine().getStatusCode(), content);
        throw new HttpStatusException(response.getStatusLine().getStatusCode(), errMsg);
    }

    private HttpServiceRequest resolveRequest(ServiceEndpoint serviceEndpoint, ServiceActionContext actionContext, Object[] args) throws IOException {
        HttpServiceRequest request;
        switch (actionContext.getRequestMethod()) {
            case GET: {
                request = this.resolveGetRequest(serviceEndpoint, actionContext, args);
                break;
            }
            case POST: 
            case PUT: {
                request = this.resolvePostOrPutRequest(serviceEndpoint, actionContext, args);
                break;
            }
            case DELETE: {
                request = this.resolveDeleteRequest(serviceEndpoint, actionContext, args);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported http method '" + (Object)((Object)actionContext.getRequestMethod()) + "'!");
            }
        }
        if (actionContext.getContentType() != null) {
            request.setHeader("Content-Type", actionContext.getContentType());
        }
        return request;
    }

    private HttpUriRequest buildRequest(ServiceRequest request) {
        ByteBuffer bodyBytes = null;
        if (request.getBody() != null) {
            bodyBytes = request.getBody();
        }
        NamedParamMap reqParams = request.getRequestParams();
        switch (request.getHttpMethod()) {
            case GET: {
                return new HttpGet(request.getUri());
            }
            case POST: {
                HttpPost httppost = new HttpPost(request.getUri());
                if (reqParams != null) {
                    NamedParam[] propNames = reqParams.getParams();
                    ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
                    for (NamedParam param : propNames) {
                        formParams.add(new BasicNameValuePair(param.getName(), param.getValue()));
                    }
                    UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(formParams, Consts.UTF_8);
                    httppost.setEntity((HttpEntity)formEntity);
                    httppost.setHeader(formEntity.getContentType());
                }
                if (bodyBytes != null) {
                    ByteArrayEntity entity = new ByteArrayEntity(bodyBytes.array());
                    httppost.setEntity((HttpEntity)entity);
                    httppost.setHeader(entity.getContentType());
                }
                return httppost;
            }
            case PUT: {
                HttpPut httpput = new HttpPut(request.getUri());
                if (reqParams != null) {
                    NamedParam[] paramValues = reqParams.getParams();
                    ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
                    for (NamedParam param : paramValues) {
                        formParams.add(new BasicNameValuePair(param.getName(), param.getValue()));
                    }
                    UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(formParams, Consts.UTF_8);
                    httpput.setEntity((HttpEntity)formEntity);
                }
                if (bodyBytes != null) {
                    ByteArrayEntity entity = new ByteArrayEntity(bodyBytes.array());
                    httpput.setEntity((HttpEntity)entity);
                }
                return httpput;
            }
            case DELETE: {
                LocalHttpDelete httpDelete = new LocalHttpDelete(request.getUri());
                if (bodyBytes != null) {
                    ByteArrayEntity entity = new ByteArrayEntity(bodyBytes.array());
                    httpDelete.setEntity((HttpEntity)entity);
                }
                return httpDelete;
            }
        }
        throw new UnsupportedOperationException("Unsupported http method '" + (Object)((Object)request.getHttpMethod()) + "'!");
    }

    private void buildAuthorization(HttpUriRequest request, RequestHeader setting) {
        request.addHeader(setting.getName(), setting.getValue());
    }

    private HttpServiceRequest resolvePostOrPutRequest(ServiceEndpoint serviceEndpoint, ServiceActionContext actionContext, Object[] args) throws IOException {
        Map<String, String> pathParams = actionContext.getPathParamResolver().resolve(args);
        HttpMethod httpMethod = actionContext.getRequestMethod();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        actionContext.getRequestBodyResolver().resolve(args, out);
        byte[] bodyBytes = out.toByteArray();
        boolean noBody = bodyBytes.length == 0;
        NamedParamMap reqParams = actionContext.getRequestParamResolver().resolve(args);
        boolean noReqParams = reqParams.isEmpty();
        actionContext.getRequestParamFilter().filter(httpMethod, reqParams);
        if (!noBody && noReqParams) {
            URI uri = actionContext.getPathTemplate().generateRequestURI(serviceEndpoint, pathParams, new NamedParamMap(), ServiceActionContext.DEFAULT_CHARSET);
            ByteBuffer body = ByteBuffer.wrap(bodyBytes);
            return new HttpServiceRequest(httpMethod, uri, null, body, args);
        }
        if (noBody && !noReqParams) {
            URI uri = actionContext.getPathTemplate().generateRequestURI(serviceEndpoint, pathParams, new NamedParamMap(), ServiceActionContext.DEFAULT_CHARSET);
            return new HttpServiceRequest(httpMethod, uri, reqParams, null, args);
        }
        if (!noBody && !noReqParams) {
            URI uri = actionContext.getPathTemplate().generateRequestURI(serviceEndpoint, pathParams, reqParams, ServiceActionContext.DEFAULT_CHARSET);
            ByteBuffer body = ByteBuffer.wrap(bodyBytes);
            return new HttpServiceRequest(httpMethod, uri, null, body, args);
        }
        URI uri = actionContext.getPathTemplate().generateRequestURI(serviceEndpoint, pathParams, new NamedParamMap(), ServiceActionContext.DEFAULT_CHARSET);
        return new HttpServiceRequest(httpMethod, uri, null, null, args);
    }

    private HttpServiceRequest resolveGetRequest(ServiceEndpoint serviceEndpoint, ServiceActionContext actionContext, Object[] args) {
        Map<String, String> pathParams = actionContext.getPathParamResolver().resolve(args);
        NamedParamMap reqParams = actionContext.getRequestParamResolver().resolve(args);
        URI uri = actionContext.getPathTemplate().generateRequestURI(serviceEndpoint, pathParams, reqParams, ServiceActionContext.DEFAULT_CHARSET);
        return new HttpServiceRequest(HttpMethod.GET, uri, null, null, args);
    }

    private HttpServiceRequest resolveDeleteRequest(ServiceEndpoint serviceEndpoint, ServiceActionContext actionContext, Object[] args) throws IOException {
        Map<String, String> pathParams = actionContext.getPathParamResolver().resolve(args);
        NamedParamMap reqParams = actionContext.getRequestParamResolver().resolve(args);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        actionContext.getRequestBodyResolver().resolve(args, out);
        byte[] bodyBytes = out.toByteArray();
        URI uri = actionContext.getPathTemplate().generateRequestURI(serviceEndpoint, pathParams, reqParams, ServiceActionContext.DEFAULT_CHARSET);
        ByteBuffer body = bodyBytes.length == 0 ? null : ByteBuffer.wrap(bodyBytes);
        return new HttpServiceRequest(HttpMethod.DELETE, uri, null, body, args);
    }

    private static class HttpServiceRequest
    implements ServiceRequest {
        private HttpMethod method;
        private URI uri;
        private ByteBuffer body;
        private Properties headers = new Properties();
        private NamedParamMap requestParams;
        private Object[] args;

        public HttpServiceRequest(HttpMethod method, URI uri, NamedParamMap requestParams, ByteBuffer body, Object[] args) {
            this.method = method;
            this.uri = uri;
            this.requestParams = requestParams;
            this.body = body;
            this.args = args;
        }

        @Override
        public HttpMethod getHttpMethod() {
            return this.method;
        }

        @Override
        public NamedParamMap getRequestParams() {
            return this.requestParams;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public ByteBuffer getBody() {
            return this.body;
        }

        public void setHeader(String name, String value) {
            this.headers.setProperty(name, value);
        }

        public Properties getHeaders() {
            return this.headers;
        }

        @Override
        public Object[] getArgs() {
            return this.args;
        }
    }

    private static class HttpServiceContextImpl
    implements HttpServiceContext {
        private Class<?> serviceClass;
        private Object proxyBindingData;

        public HttpServiceContextImpl(Class<?> serviceClass, Object proxyBindingData) {
            this.serviceClass = serviceClass;
            this.proxyBindingData = proxyBindingData;
        }

        @Override
        public Class<?> getServiceClasss() {
            return this.serviceClass;
        }

        @Override
        public Object getProxyBindingData() {
            return this.proxyBindingData;
        }
    }

    private static class ServiceInvocationHandler
    implements InvocationHandler,
    HttpServiceContext,
    HttpServiceProxy {
        private HttpServiceAgent serviceAgent;
        private HttpServiceConnection connection;
        private RequestHeader[] headers;
        private Object bindingData;

        public ServiceInvocationHandler(HttpServiceAgent serviceAgent, HttpServiceConnection connection, RequestHeader[] headers, Object bindingData) {
            this.serviceAgent = serviceAgent;
            this.connection = connection;
            this.headers = headers;
            this.bindingData = bindingData;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == HttpServiceProxy.class) {
                return method.invoke((Object)this, args);
            }
            return this.serviceAgent.invoke(this.connection.getEndpoint(), this, this.connection.getHttpClient(), this.headers, method, args);
        }

        @Override
        public Class<?> getServiceClasss() {
            return this.serviceAgent.serviceClass;
        }

        @Override
        public Object getProxyBindingData() {
            return this.bindingData;
        }

        @Override
        public ServiceEndpoint getServiceEndpoint() {
            return this.connection.getEndpoint();
        }

        @Override
        public void close() throws IOException {
            this.connection.close();
        }
    }
}

