/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.agent;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientPool {
    private static final int TIME_OUT = 10000;
    private static final int CONNECT_TIME_OUT = 10000;
    private static final int SOCKET_TIME_OUT = 10000;
    private static final int MAX_TOTAL = 200;
    private static final int MAX_PER_ROUTE = 40;
    private static final int MAX_ROUTE = 100;
    private static final int RETRY_COUNT = 5;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final Map<String, CloseableHttpClient> httpClients = new ConcurrentHashMap<String, CloseableHttpClient>();
    private static final Lock lock = new ReentrantLock();

    private static void config(HttpRequestBase httpRequestBase) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(10000).build();
        httpRequestBase.setConfig(requestConfig);
    }

    public static CloseableHttpClient getHttpClient(String url) {
        String hostName = url.split("/")[2];
        int port = 80;
        if (hostName.contains(":")) {
            String[] arr = hostName.split(":");
            hostName = arr[0];
            port = Integer.parseInt(arr[1]);
        }
        return HttpClientPool.getHttpClient(hostName, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient getHttpClient(String hostName, int port) {
        String key = hostName + ":" + port;
        CloseableHttpClient httpClient = httpClients.get(key);
        if (httpClient == null) {
            try {
                lock.lock();
                if (httpClient == null) {
                    httpClient = HttpClientPool.createHttpClient(200, 40, 100, hostName, port);
                    httpClients.put(key, httpClient);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return httpClient;
    }

    public static CloseableHttpClient createHttpClient(int maxTotal, int maxPerRoute, int maxRoute, String hostname, int port) {
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslsf = SSLConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        cm.setMaxTotal(maxTotal);
        cm.setDefaultMaxPerRoute(maxPerRoute);
        HttpHost httpHost = new HttpHost(hostname, port);
        cm.setMaxPerRoute(new HttpRoute(httpHost), maxRoute);
        HttpRequestRetryHandler httpRequestRetryHandler = (exception, executionCount, context) -> {
            if (executionCount >= 5) {
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                return true;
            }
            if (exception instanceof SSLException) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return false;
            }
            if (exception instanceof SSLHandshakeException) {
                return false;
            }
            if (exception instanceof UnknownHostException) {
                return false;
            }
            if (exception instanceof ConnectTimeoutException) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpRequest request = clientContext.getRequest();
            return !(request instanceof HttpEntityEnclosingRequest);
        };
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler(httpRequestRetryHandler).build();
        return httpClient;
    }

    private static void setPostParams(HttpPost httpPost, Map<String, Object> params) {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        Set<String> keySet = params.keySet();
        for (String key : keySet) {
            nameValuePairs.add(new BasicNameValuePair(key, params.get(key).toString()));
        }
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static String post(String url, Map<String, Object> params) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        HttpClientPool.config((HttpRequestBase)httpPost);
        HttpClientPool.setPostParams(httpPost, params);
        try (CloseableHttpResponse response = HttpClientPool.httpPost(url, httpPost);){
            String string = HttpClientPool.parseResponse(response);
            return string;
        }
    }

    public static String get(String url) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        HttpClientPool.config((HttpRequestBase)httpGet);
        try (CloseableHttpResponse response = HttpClientPool.httpGet(url, httpGet);){
            String string = HttpClientPool.parseResponse(response);
            return string;
        }
    }

    private static CloseableHttpResponse httpGet(String url, HttpGet httpGet) throws IOException {
        return HttpClientPool.getHttpClient(url).execute((HttpUriRequest)httpGet, (HttpContext)HttpClientContext.create());
    }

    private static CloseableHttpResponse httpPost(String url, HttpPost httpPost) throws IOException {
        return HttpClientPool.getHttpClient(url).execute((HttpUriRequest)httpPost, (HttpContext)HttpClientContext.create());
    }

    private static String parseResponse(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        String result = EntityUtils.toString((HttpEntity)entity, (String)DEFAULT_CHARSET);
        EntityUtils.consume((HttpEntity)entity);
        return result;
    }

    public static String jsonPost(String url, String json) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        HttpClientPool.config((HttpRequestBase)httpPost);
        HttpClientPool.setJsonPostParams(httpPost, json);
        try (CloseableHttpResponse response = HttpClientPool.httpPost(url, httpPost);){
            String string = HttpClientPool.parseResponse(response);
            return string;
        }
    }

    private static void setJsonPostParams(HttpPost httpPost, String json) {
        httpPost.addHeader("Content-type", "application/json; charset=utf-8");
        httpPost.setHeader("Accept", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(json, Charset.forName(DEFAULT_CHARSET)));
    }
}

