/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice;

import com.jd.httpservice.NamedParam;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NamedParamMap {
    private Map<String, List<NamedParam>> params = new LinkedHashMap<String, List<NamedParam>>();

    public NamedParam[] getParams() {
        ArrayList<NamedParam> allParams = new ArrayList<NamedParam>();
        for (List<NamedParam> namedParams : this.params.values()) {
            allParams.addAll(namedParams);
        }
        return allParams.toArray(new NamedParam[allParams.size()]);
    }

    public NamedParam addParam(String name, String value) {
        List<NamedParam> values = this.params.get(name);
        if (values == null) {
            values = new ArrayList<NamedParam>();
            this.params.put(name, values);
        }
        NamedParam p = new NamedParam(name, value);
        values.add(p);
        return p;
    }

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public void merge(NamedParamMap extParams) {
        this.merge(extParams, null);
    }

    public void merge(NamedParamMap extParams, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            NamedParam[] paramArr;
            for (NamedParam np : paramArr = extParams.getParams()) {
                this.addParam(np.getName(), np.getValue());
            }
        } else {
            NamedParam[] paramArr;
            for (NamedParam np : paramArr = extParams.getParams()) {
                this.addParam(prefix + np.getName(), np.getValue());
            }
        }
    }
}

