/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.actions.sequence.SequenceId;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.layout.properties.BaseDirection;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.typography.AbstractTypographyApplier;
import com.itextpdf.layout.renderer.typography.DefaultTypographyApplier;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class TypographyUtils {
    private static final String TYPOGRAPHY_PACKAGE = "com.itextpdf.typography.";
    private static final String TYPOGRAPHY_APPLIER = "shaping.TypographyApplier";
    private static final String TYPOGRAPHY_APPLIER_INITIALIZE = "registerForLayout";
    private static AbstractTypographyApplier applierInstance;

    private TypographyUtils() {
    }

    public static void setTypographyApplierInstance(AbstractTypographyApplier newInstance) {
        applierInstance = newInstance;
    }

    public static boolean isPdfCalligraphAvailable() {
        return applierInstance.isPdfCalligraphInstance();
    }

    public static Collection<Character.UnicodeScript> getSupportedScripts() {
        return applierInstance.getSupportedScripts();
    }

    public static Collection<Character.UnicodeScript> getSupportedScripts(Object typographyConfig) {
        return applierInstance.getSupportedScripts(typographyConfig);
    }

    public static Map<String, byte[]> loadShippedFonts() throws IOException {
        return applierInstance.loadShippedFonts();
    }

    static void applyOtfScript(FontProgram fontProgram, GlyphLine text, Character.UnicodeScript script, Object typographyConfig, SequenceId sequenceId, IMetaInfo metaInfo) {
        applierInstance.applyOtfScript((TrueTypeFont)fontProgram, text, script, typographyConfig, sequenceId, metaInfo);
    }

    static void applyKerning(FontProgram fontProgram, GlyphLine text, SequenceId sequenceId, IMetaInfo metaInfo) {
        applierInstance.applyKerning(fontProgram, text, sequenceId, metaInfo);
    }

    static byte[] getBidiLevels(BaseDirection baseDirection, int[] unicodeIds, SequenceId sequenceId, IMetaInfo metaInfo) {
        return applierInstance.getBidiLevels(baseDirection, unicodeIds, sequenceId, metaInfo);
    }

    static int[] reorderLine(List<LineRenderer.RendererGlyph> line, byte[] lineLevels, byte[] levels) {
        return applierInstance.reorderLine(line, lineLevels, levels);
    }

    static List<Integer> getPossibleBreaks(String str) {
        return applierInstance.getPossibleBreaks(str);
    }

    private static Class<?> getTypographyClass(String typographyClassName) throws ClassNotFoundException {
        return Class.forName(typographyClassName);
    }

    static {
        try {
            Method method;
            Class<?> type = TypographyUtils.getTypographyClass("com.itextpdf.typography.shaping.TypographyApplier");
            if (type != null && (method = type.getMethod(TYPOGRAPHY_APPLIER_INITIALIZE, new Class[0])) != null) {
                method.invoke(null, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (applierInstance == null) {
            TypographyUtils.setTypographyApplierInstance(new DefaultTypographyApplier());
        }
    }
}

