/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.html2pdf.attach.wrapelement.TableRowWrapper;
import com.itextpdf.html2pdf.attach.wrapelement.TableWrapper;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.ILeafElement;

public class DisplayTableRowTagWorker
implements ITagWorker {
    private TableRowWrapper rowWrapper = new TableRowWrapper();
    private WaitingInlineElementsHelper inlineHelper;
    private Cell waitingCell = null;

    public DisplayTableRowTagWorker(IElementNode element, ProcessorContext context) {
        this.inlineHelper = new WaitingInlineElementsHelper(element.getStyles().get("white-space"), element.getStyles().get("text-transform"));
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        this.flushWaitingCell();
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        boolean displayTableCell;
        boolean bl = displayTableCell = childTagWorker instanceof IDisplayAware && "table-cell".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay());
        if (childTagWorker.getElementResult() instanceof IBlockElement) {
            IBlockElement childResult = (IBlockElement)childTagWorker.getElementResult();
            Cell curCell = childResult instanceof Cell ? (Cell)childResult : this.createWrapperCell().add(childResult);
            this.processCell(curCell, displayTableCell);
            return true;
        }
        if (childTagWorker.getElementResult() instanceof ILeafElement) {
            this.inlineHelper.add((ILeafElement)childTagWorker.getElementResult());
            return true;
        }
        if (childTagWorker instanceof SpanTagWorker) {
            if (displayTableCell) {
                this.flushWaitingCell();
            }
            boolean allChildrenProcessed = true;
            for (IPropertyContainer propertyContainer : ((SpanTagWorker)childTagWorker).getAllElements()) {
                if (propertyContainer instanceof ILeafElement) {
                    this.inlineHelper.add((ILeafElement)propertyContainer);
                    continue;
                }
                allChildrenProcessed = false;
            }
            if (displayTableCell) {
                this.flushWaitingCell();
            }
            return allChildrenProcessed;
        }
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        TableWrapper tableWrapper = new TableWrapper();
        for (Cell cell : this.rowWrapper.getCells()) {
            tableWrapper.addCell(cell);
        }
        return tableWrapper.toTable(null);
    }

    public TableRowWrapper getTableRowWrapper() {
        return this.rowWrapper;
    }

    private void processCell(Cell cell, boolean displayTableCell) {
        if (displayTableCell) {
            if (this.waitingCell != cell) {
                this.flushWaitingCell();
                this.rowWrapper.addCell(cell);
            } else if (!cell.isEmpty()) {
                this.rowWrapper.addCell(cell);
                this.waitingCell = null;
            }
        } else {
            this.flushInlineElementsToWaitingCell();
            this.waitingCell.add((IBlockElement)cell);
        }
    }

    private void flushInlineElementsToWaitingCell() {
        if (null == this.waitingCell) {
            this.waitingCell = this.createWrapperCell();
        }
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)this.waitingCell);
    }

    private void flushWaitingCell() {
        this.flushInlineElementsToWaitingCell();
        if (null != this.waitingCell) {
            this.processCell(this.waitingCell, true);
        }
    }

    private Cell createWrapperCell() {
        return (Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setPadding(0.0f);
    }
}

