/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.fsp.shield.java.sdk.websocket;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.iflytek.fsp.shield.java.sdk.enums.SignType;
import com.iflytek.fsp.shield.java.sdk.icloudlock.CodeManager;
import com.iflytek.fsp.shield.java.sdk.util.SignUtil;
import com.iflytek.fsp.shield.java.sdk.util.gmcrypto.SM3Util;
import java.util.UUID;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseApp {
    private static Logger logger = LoggerFactory.getLogger(BaseApp.class);
    protected String host;
    protected int webSocketPort;
    protected String appId;
    protected String appSecret;
    protected String gmAppSecret;
    protected String stage;
    protected String publicKey;
    protected String gmPublicKey;
    protected String gmPrivateKey;
    protected String equipmentNo;
    protected String signStrategyUrl;
    protected String tokenUrl;
    protected boolean icloudlockEnabled = false;

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getEquipmentNo() {
        return this.equipmentNo;
    }

    public void setEquipmentNo(String equipmentNo) {
        this.equipmentNo = equipmentNo;
    }

    public String getSignStrategyUrl() {
        return this.signStrategyUrl;
    }

    public void setSignStrategyUrl(String signStrategyUrl) {
        this.signStrategyUrl = signStrategyUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public int getWebSocketPort() {
        return this.webSocketPort;
    }

    public void setWebSocketPort(int webSocketPort) {
        this.webSocketPort = webSocketPort;
    }

    public boolean isIcloudlockEnabled() {
        return this.icloudlockEnabled;
    }

    public void setIcloudlockEnabled(boolean icloudlockEnabled) {
        this.icloudlockEnabled = icloudlockEnabled;
    }

    public String getGmAppSecret() {
        return this.gmAppSecret;
    }

    public void setGmAppSecret(String gmAppSecret) {
        this.gmAppSecret = gmAppSecret;
    }

    public String getGmPublicKey() {
        return this.gmPublicKey;
    }

    public void setGmPublicKey(String gmPublicKey) {
        this.gmPublicKey = gmPublicKey;
    }

    public String getGmPrivateKey() {
        return this.gmPrivateKey;
    }

    public void setGmPrivateKey(String gmPrivateKey) {
        this.gmPrivateKey = gmPrivateKey;
    }

    public JSONObject getBaseContent(String url, JSONObject querys, JSONObject pathParams, String signType) {
        long timestamp = System.currentTimeMillis();
        String uuid = UUID.randomUUID().toString();
        String signature = null;
        signature = signType.equalsIgnoreCase(SignType.GM.name()) ? SM3Util.signws(this.gmAppSecret, url, uuid, Long.toString(timestamp), this.appId) : (signType.equalsIgnoreCase(SignType.SIMPLE.name()) ? SignUtil.simpleSign(this.appSecret, uuid, Long.toString(timestamp)) : SignUtil.signws(this.appSecret, url, uuid, Long.toString(timestamp), this.appId));
        JSONObject jsonObject = new JSONObject();
        JSONObject headers = new JSONObject();
        headers.put("S-Auth-AppId", (Object)this.appId);
        headers.put("S-Auth-Nonce", (Object)uuid);
        headers.put("S-Auth-Signature", (Object)signature);
        headers.put("S-Auth-Stage", (Object)this.stage);
        headers.put("S-Auth-Timestamp", (Object)timestamp);
        headers.put("S-Auth-Version", (Object)"1");
        headers.put("S-Auth-EquipmentNo", (Object)this.equipmentNo);
        if (this.icloudlockEnabled) {
            headers.put("S-Auth-CODE", (Object)CodeManager.getInstance().getCode());
        }
        jsonObject.put("headers", (Object)headers);
        jsonObject.put("path", (Object)url);
        jsonObject.put("pathParams", (Object)pathParams);
        jsonObject.put("querys", (Object)querys);
        return jsonObject;
    }

    public void send(String data, String url, JSONObject querys, JSONObject pathParams, WebSocketClient apiClient, String signType) {
        this.send(data.getBytes(), url, querys, pathParams, apiClient, signType);
    }

    public void send(byte[] data, String url, JSONObject querys, JSONObject pathParams, WebSocketClient apiClient, String signType) {
        JSONObject jsonObject = this.getBaseContent(url, querys, pathParams, signType);
        jsonObject.put("body", (Object)data);
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String dataStr = gson.toJson((Object)jsonObject);
        while (!apiClient.getReadyState().equals((Object)WebSocket.READYSTATE.OPEN)) {
            logger.debug("\u6b63\u5728\u5efa\u7acb\u8fde\u63a5......");
        }
        apiClient.send(dataStr);
    }

    public String getUrl(String path, JSONObject querys, JSONObject pathParams) {
        boolean flag;
        String url = path;
        String querysStr = "";
        if (querys != null) {
            for (String key : querys.keySet()) {
                querysStr = querysStr + key + "=" + querys.get((Object)key) + "&";
            }
        }
        boolean bl = flag = (url = url + "?" + querysStr).endsWith("&") || url.endsWith("?");
        if (flag) {
            url = url.substring(0, url.length() - 1);
        }
        if (pathParams != null) {
            for (String key : pathParams.keySet()) {
                url = url.replace("[" + key + "]", pathParams.get((Object)key).toString());
            }
        }
        return url;
    }
}

