/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.fsp.shield.java.sdk.util.gmcrypto;

import com.iflytek.fsp.shield.java.sdk.util.gmcrypto.SM4Instance;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4Util {
    private static final Logger logger = LoggerFactory.getLogger(SM4Util.class);

    public static byte[] enDecryptData(Key key, boolean encryptOrDecrypt, byte[] srcData) throws Exception {
        Cipher sm4Engine = SM4Instance.getInstance();
        if (encryptOrDecrypt) {
            sm4Engine.init(1, key);
            byte[] enc = sm4Engine.doFinal(srcData);
            return enc;
        }
        sm4Engine.init(2, key);
        byte[] dec = sm4Engine.doFinal(srcData);
        return dec;
    }

    public static String enDecryptDataBackStr(Key key, boolean encryptOrDecrypt, byte[] srcData) throws Exception {
        byte[] tmpData = srcData;
        if (!encryptOrDecrypt) {
            tmpData = Base64.decodeBase64((byte[])srcData);
        }
        return Base64.encodeBase64String((byte[])SM4Util.enDecryptData(key, encryptOrDecrypt, tmpData));
    }

    public static byte[] enDecryptDataByInputKey(String inputKey, boolean encryptOrDecrypt, byte[] srcData) throws Exception {
        Key key = SM4Util.getKey(inputKey);
        byte[] tmpData = srcData;
        if (!encryptOrDecrypt) {
            tmpData = Base64.decodeBase64((byte[])srcData);
        }
        return SM4Util.enDecryptData(key, encryptOrDecrypt, tmpData);
    }

    public static String enDecryptDataByInputKeyBackStr(String inputKey, boolean encryptOrDecrypt, byte[] srcData) throws Exception {
        Key key = SM4Util.getKey(inputKey);
        byte[] tmpData = srcData;
        if (!encryptOrDecrypt) {
            tmpData = Base64.decodeBase64((byte[])srcData);
        }
        return SM4Util.enDecryptDataBackStr(key, encryptOrDecrypt, tmpData);
    }

    public static Key getKey(String inputKey) {
        String tmpKey = "0123456789abcdeffedcba9876543210";
        if (!StringUtils.isEmpty((String)inputKey)) {
            tmpKey = inputKey;
        }
        return new SecretKeySpec(Hex.decode((String)tmpKey), "SM4");
    }

    public static void main(String[] args) throws Exception {
        Key kp = SM4Util.getKey("");
        String str = "\u4f60\u597d";
        String out = SM4Util.enDecryptDataBackStr(kp, true, Strings.toUTF8ByteArray((String)str));
        String in = SM4Util.enDecryptDataBackStr(kp, false, out.getBytes("UTF-8"));
        System.out.println(str.equalsIgnoreCase(new String(Base64.decodeBase64((String)in))));
    }

    static {
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

