/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.fsp.shield.java.sdk.util.gmcrypto;

import com.iflytek.fsp.shield.java.sdk.util.gmcrypto.HMacInstance;
import com.iflytek.fsp.shield.java.sdk.util.gmcrypto.SM3Instance;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Strings;

public class SM3Util {
    public static final String ENCODING = "UTF-8";
    public static final String SEPARATOR = "|";

    public static String sign(byte[] srcData) {
        SM3Digest sm3Digest = SM3Instance.getInstance();
        sm3Digest.update(srcData, 0, srcData.length);
        byte[] resBuf = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(resBuf, 0);
        return Base64.encodeBase64String((byte[])resBuf);
    }

    public static String signByKey(byte[] key, byte[] srcData) {
        HMac mac = HMacInstance.getInstance();
        mac.init((CipherParameters)new KeyParameter(key));
        mac.update(srcData, 0, srcData.length);
        byte[] resBuf = new byte[mac.getMacSize()];
        mac.doFinal(resBuf, 0);
        return Base64.encodeBase64String((byte[])resBuf);
    }

    public static String generateSecrityKey(String appId) throws Exception {
        return SM3Util.sign((appId + System.currentTimeMillis()).getBytes());
    }

    public static String signUrlParam(String secret, String url, String authRandomKey, String authNonce, String authTimestamp, String authAppId, String contentSign) {
        try {
            String[] values = new String[]{url, authRandomKey, authNonce, authTimestamp, authAppId, contentSign};
            String stringToSign = SM3Util.buildStringToSign(values);
            byte[] keyBytes = secret.getBytes(ENCODING);
            return SM3Util.signByKey(keyBytes, stringToSign.getBytes(ENCODING));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String signws(String secret, String url, String authNonce, String authTimestamp, String authAppId) {
        try {
            String[] values = new String[]{url, authNonce, authTimestamp, authAppId};
            String stringToSign = SM3Util.buildStringToSign(values);
            byte[] keyBytes = secret.getBytes(ENCODING);
            return SM3Util.signByKey(keyBytes, stringToSign.getBytes(ENCODING));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String buildStringToSign(String[] headValues) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < headValues.length; ++i) {
            if (!StringUtils.isNotEmpty((CharSequence)headValues[i])) continue;
            sb.append(headValues[i]).append(SEPARATOR);
        }
        String stringToSign = sb.substring(0, sb.lastIndexOf(SEPARATOR));
        return stringToSign;
    }

    public static void main(String[] args) {
        String str = "\u4f60\u597d";
        String keyStr = "12312";
        String signStr = SM3Util.signByKey(keyStr.getBytes(), Strings.toUTF8ByteArray((String)str));
        System.out.println(signStr);
    }

    static {
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

