/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.fsp.shield.java.sdk.util.gmcrypto;

import com.iflytek.fsp.shield.java.sdk.util.gmcrypto.SM24SM3CliperInstance;
import com.iflytek.fsp.shield.java.sdk.util.gmcrypto.SM2CliperInstance;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2Util {
    private static final Logger logger = LoggerFactory.getLogger(SM2Util.class);

    public static byte[] encryptByte(String publicKey, byte[] srcData) throws Exception {
        Cipher sm2CipherEngine = SM2CliperInstance.getInstance();
        sm2CipherEngine.init(1, (Key)SM2Util.restorePublicKey(Hex.decodeHex((String)publicKey)), SM2Util.getSecureRandom());
        byte[] enc = sm2CipherEngine.doFinal(srcData);
        return enc;
    }

    public static String encrypt(String publicKey, byte[] srcData) throws Exception {
        return Base64.encodeBase64String((byte[])SM2Util.encryptByte(publicKey, srcData));
    }

    public static String encrypt(String publicKey, String srcData) throws Exception {
        return SM2Util.encrypt(publicKey, Strings.toUTF8ByteArray((String)srcData));
    }

    public static byte[] encryptBackByte(String publicKey, String srcData) throws Exception {
        return SM2Util.encryptByte(publicKey, Strings.toUTF8ByteArray((String)srcData));
    }

    public static byte[] decryptByte(String privateKey, byte[] cipherData) throws Exception {
        Cipher sm2CipherEngine = SM2CliperInstance.getInstance();
        sm2CipherEngine.init(2, SM2Util.restorePrivateKey(Hex.decodeHex((String)privateKey)));
        byte[] dec = sm2CipherEngine.doFinal(cipherData);
        return dec;
    }

    public static String decrypt(String privateKey, byte[] cipherData) throws Exception {
        return Strings.fromUTF8ByteArray((byte[])SM2Util.decryptByte(privateKey, cipherData));
    }

    public static String decrypt(String privateKey, String cipherData) throws Exception {
        return SM2Util.decrypt(privateKey, Base64.decodeBase64((String)cipherData));
    }

    public static byte[] decryptBackByte(String privateKey, String cipherData) throws Exception {
        return SM2Util.decryptByte(privateKey, Strings.toByteArray((String)cipherData));
    }

    public static byte[] signWithSM3(String privateKey, byte[] srcData) throws Exception {
        Signature sm2SignerEngine = SM24SM3CliperInstance.getInstance();
        sm2SignerEngine.setParameter((AlgorithmParameterSpec)new SM2ParameterSpec(Strings.toByteArray((String)"123456")));
        sm2SignerEngine.initSign(SM2Util.restorePrivateKey(Hex.decodeHex((String)privateKey)), SM2Util.getSecureRandom());
        sm2SignerEngine.update(srcData, 0, srcData.length);
        byte[] sig = sm2SignerEngine.sign();
        return sig;
    }

    public static boolean verifySign(String publicKey, byte[] srcData, byte[] signedData) throws Exception {
        Signature verifier = SM24SM3CliperInstance.getInstance();
        verifier.setParameter((AlgorithmParameterSpec)new SM2ParameterSpec(Strings.toByteArray((String)"123456")));
        verifier.initVerify(SM2Util.restorePublicKey(Hex.decodeHex((String)publicKey)));
        verifier.update(srcData, 0, srcData.length);
        return verifier.verify(signedData);
    }

    public static SecureRandom getSecureRandom() throws Exception {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        return random;
    }

    public static PublicKey restorePublicKey(byte[] keyBytes) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("EC", "BC");
        PublicKey publicKey = factory.generatePublic(x509EncodedKeySpec);
        return publicKey;
    }

    public static PrivateKey restorePrivateKey(byte[] keyBytes) throws Exception {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("EC", "BC");
        PrivateKey privateKey = factory.generatePrivate(pkcs8EncodedKeySpec);
        return privateKey;
    }

    static {
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

