/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.fsp.shield.java.sdk.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class SignUtil {
    public static final String ENCODING = "UTF-8";
    public static final String HMAC_SHA256 = "HmacSHA256";
    public static final String SEPARATOR = "|";

    public static void main(String[] args) {
        System.out.println(SignUtil.sign("testSecret", "/test", "", "03f7cede98f74c6db88d8c810dbac9b0", "1558428816", "testApp", ""));
    }

    public static String sign(String secret, String url, String authRandomKey, String authNonce, String authTimestamp, String authAppId, String contentMD5) {
        try {
            String[] values = new String[]{url, authRandomKey, authNonce, authTimestamp, authAppId, contentMD5};
            String stringToSign = SignUtil.buildStringToSign(values);
            Mac hmacSha256 = Mac.getInstance(HMAC_SHA256);
            byte[] keyBytes = secret.getBytes(ENCODING);
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, HMAC_SHA256));
            return Base64.encodeBase64String((byte[])hmacSha256.doFinal(stringToSign.getBytes(ENCODING)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String signws(String secret, String url, String authNonce, String authTimestamp, String authAppId) {
        try {
            String[] values = new String[]{url, authNonce, authTimestamp, authAppId};
            String stringToSign = SignUtil.buildStringToSign(values);
            Mac hmacSha256 = Mac.getInstance(HMAC_SHA256);
            byte[] keyBytes = secret.getBytes(ENCODING);
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, HMAC_SHA256));
            return Base64.encodeBase64String((byte[])hmacSha256.doFinal(stringToSign.getBytes(ENCODING)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String simpleSign(String secret, String authNonce, String authTimestamp) {
        try {
            String[] values = new String[]{secret, authNonce, authTimestamp};
            String stringToSign = SignUtil.buildStringToSign(values);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(stringToSign.getBytes(ENCODING));
            return Base64.encodeBase64String((byte[])md.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String buildStringToSign(String[] headValues) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < headValues.length; ++i) {
            if (!StringUtils.isNotEmpty((CharSequence)headValues[i])) continue;
            sb.append(headValues[i]).append(SEPARATOR);
        }
        String stringToSign = sb.substring(0, sb.lastIndexOf(SEPARATOR));
        return stringToSign;
    }

    public static String md5ThenBase64(byte[] bytes) {
        try {
            String aa = bytes.toString();
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            String dd = md5.digest(bytes).toString();
            String newstr = Base64.encodeBase64String((byte[])md5.digest(bytes));
            return newstr;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("unknown algorithm MD5");
        }
    }
}

