/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.fsp.shield.java.sdk.http;

import com.alibaba.fastjson.JSONObject;
import com.iflytek.fsp.shield.java.sdk.enums.Method;
import com.iflytek.fsp.shield.java.sdk.enums.SignType;
import com.iflytek.fsp.shield.java.sdk.exception.SdkClientException;
import com.iflytek.fsp.shield.java.sdk.http.ApiClient;
import com.iflytek.fsp.shield.java.sdk.model.ApiCallback;
import com.iflytek.fsp.shield.java.sdk.model.ApiRequest;
import com.iflytek.fsp.shield.java.sdk.model.ApiResponse;
import com.iflytek.fsp.shield.java.sdk.model.ApiSignStrategy;
import com.iflytek.fsp.shield.java.sdk.model.MultiApiCallback;
import com.iflytek.fsp.shield.java.sdk.model.ResultInfo;
import com.iflytek.fsp.shield.java.sdk.util.CryptoUtils;
import com.iflytek.fsp.shield.java.sdk.util.RequestUtil;
import com.iflytek.fsp.shield.java.sdk.util.gmcrypto.SM2Util;
import com.iflytek.fsp.shield.java.sdk.util.gmcrypto.SM4Util;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class BaseApp {
    protected String host;
    protected int httpPort;
    protected int httpsPort;
    protected String contextPath;
    protected String appId;
    protected String appSecret;
    protected String gmAppSecret;
    protected String stage;
    protected String publicKey;
    protected String gmPublicKey;
    protected String gmPrivateKey;
    protected String equipmentNo;
    protected String signStrategyUrl;
    protected String tokenUrl;
    protected ApiClient apiClient;
    protected boolean icloudlockEnabled = false;

    public ApiSignStrategy getSignStrategy(String apiPath) {
        ApiSignStrategy apiSignStrategy = null;
        ApiRequest apiRequest = new ApiRequest("HTTP", Method.valueOf("POST"), this.signStrategyUrl, 0, SignType.DEFAULT.name(), null);
        apiRequest.getHeaders().appendOne("S-Strategy-ApiPath", apiPath);
        apiRequest.getHeaders().appendOne("S-Strategy-ApiStage", this.stage);
        apiRequest = this.handleRequest(apiRequest);
        ApiResponse apiResponse = this.apiClient.syncRequest(apiRequest);
        apiResponse = this.handleResponse(apiResponse, apiRequest.getAuthType());
        try {
            String content = new String(apiResponse.getBody(), "UTF-8");
            apiSignStrategy = (ApiSignStrategy)JSONObject.parseObject((String)content, ApiSignStrategy.class);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return apiSignStrategy;
    }

    public ResultInfo getTokenInfo(ApiSignStrategy signStrategy) {
        ResultInfo resultInfo = null;
        ApiRequest apiRequest = new ApiRequest("HTTP", Method.valueOf("POST"), this.tokenUrl, 0, SignType.DEFAULT.name(), null);
        apiRequest.getHeaders().appendOne("S-Token-Version", "V1.1.1");
        apiRequest.getHeaders().appendOne("S-Token-AppId", this.appId);
        apiRequest.getHeaders().appendOne("S-Token-EquipmentNo", this.equipmentNo);
        apiRequest.getHeaders().appendOne("S-Token-Stage", this.stage);
        Integer tokenExpire = this.calExpire(signStrategy.getTimeUnit(), signStrategy.getTokenEffectiveTime());
        apiRequest.getHeaders().appendOne("S-Token-Expire", String.valueOf(tokenExpire));
        if (null != signStrategy.getTokenCount() && signStrategy.getTokenCount() > 0) {
            apiRequest.getHeaders().appendOne("S-Token-Count", String.valueOf(signStrategy.getTokenCount()));
        }
        apiRequest = this.handleRequest(apiRequest);
        ApiResponse apiResponse = this.apiClient.syncRequest(apiRequest);
        apiResponse = this.handleResponse(apiResponse, apiRequest.getAuthType());
        try {
            String content = new String(apiResponse.getBody(), "UTF-8");
            resultInfo = (ResultInfo)JSONObject.parseObject((String)content, ResultInfo.class);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return resultInfo;
    }

    public ApiResponse syncInvoke(ApiRequest apiRequest) {
        if (apiRequest == null) {
            return null;
        }
        apiRequest = this.handleRequest(apiRequest);
        ApiResponse apiResponse = this.apiClient.syncRequest(apiRequest);
        apiResponse = this.handleResponse(apiResponse, apiRequest.getAuthType());
        return apiResponse;
    }

    public List<ApiResponse> syncMultiInvokes(List<ApiRequest> apiRequests) {
        if (apiRequests == null || apiRequests.size() == 0) {
            return null;
        }
        ArrayList<ApiResponse> list = new ArrayList<ApiResponse>(apiRequests.size());
        for (int i = 0; i < apiRequests.size(); ++i) {
            ApiResponse apiResponse = this.syncInvoke(apiRequests.get(i));
            list.add(apiResponse);
        }
        return list;
    }

    public Future<ApiResponse> asyncInvoke(final ApiRequest apiRequest, final ApiCallback callback) {
        if (apiRequest == null) {
            return null;
        }
        this.handleRequest(apiRequest);
        return this.apiClient.asyncRequest(apiRequest, new ApiCallback(){

            @Override
            public void onResponse(ApiRequest request, ApiResponse response) {
                if (callback != null) {
                    response = BaseApp.this.handleResponse(response, apiRequest.getAuthType());
                    callback.onResponse(request, response);
                }
            }

            @Override
            public void onFailure(ApiRequest request, Exception e) {
                if (callback != null) {
                    callback.onFailure(request, e);
                }
            }
        });
    }

    public void asyncMultiInvokes(final List<ApiRequest> apiRequests, final MultiApiCallback multiApiCallback) {
        if (apiRequests == null || apiRequests.size() == 0) {
            return;
        }
        final HashMap responseMap = new HashMap(apiRequests.size());
        final Semaphore semap = new Semaphore(0);
        for (int i = 0; i < apiRequests.size(); ++i) {
            this.asyncInvoke(apiRequests.get(i), i, responseMap, semap);
        }
        if (multiApiCallback != null) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < apiRequests.size(); ++i) {
                        semap.acquireUninterruptibly();
                    }
                    ArrayList list = new ArrayList();
                    for (int i = 0; i < apiRequests.size(); ++i) {
                        list.add(responseMap.get(i));
                    }
                    multiApiCallback.onResponses(list);
                }
            });
            thread.start();
        }
    }

    private void asyncInvoke(ApiRequest apiRequest, int index, final Map responseMap, final Semaphore semap) {
        final Integer key = index;
        this.asyncInvoke(apiRequest, new ApiCallback(){

            @Override
            public void onResponse(ApiRequest request, ApiResponse response) {
                responseMap.put(key, response);
                semap.release();
            }

            @Override
            public void onFailure(ApiRequest request, Exception e) {
                responseMap.put(key, e);
                semap.release();
            }
        });
    }

    private ApiRequest handleRequest(ApiRequest apiRequest) {
        apiRequest.setHost(this.host);
        if (!StringUtils.isEmpty((String)this.contextPath)) {
            String reqPath = apiRequest.getPath();
            reqPath = "/" + this.contextPath + reqPath;
            apiRequest.setPath(reqPath);
        }
        if ("HTTP".equals(apiRequest.getScheme())) {
            apiRequest.setPort(this.httpPort);
        } else if ("HTTPS".equals(apiRequest.getScheme())) {
            apiRequest.setPort(this.httpsPort);
        }
        if (apiRequest.getAuthType() == 1) {
            apiRequest = RequestUtil.cryptRequest(apiRequest, this.publicKey, apiRequest.getAuthType());
        } else if (apiRequest.getAuthType() == 2) {
            apiRequest = RequestUtil.cryptRequest(apiRequest, this.gmPublicKey, apiRequest.getAuthType());
        } else if (apiRequest.getAuthType() == 3) {
            apiRequest = RequestUtil.cryptRequest(apiRequest, this.publicKey, apiRequest.getAuthType());
        }
        String secret = this.appSecret;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)apiRequest.getTokenValue())) {
            secret = apiRequest.getTokenValue();
        }
        if (apiRequest.getSignType().equalsIgnoreCase(SignType.GM.name())) {
            secret = this.gmAppSecret;
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)apiRequest.getGmTokenValue())) {
            secret = apiRequest.getGmTokenValue();
        }
        apiRequest = RequestUtil.buildSdkRequest(apiRequest, this.appId, secret, this.stage, this.icloudlockEnabled, apiRequest.getSignType());
        return apiRequest;
    }

    private ApiResponse handleResponse(ApiResponse apiResponse, int authType) {
        if ((authType == 1 || authType == 2 || authType == 3) && ArrayUtils.isNotEmpty((byte[])apiResponse.getBody())) {
            try {
                String head = apiResponse.getHeaders().get("S-Auth-RandomKey");
                if (authType == 2) {
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)head)) {
                        apiResponse.setBody(SM4Util.enDecryptDataByInputKey(SM2Util.decrypt(this.gmPrivateKey, head), false, apiResponse.getBody()));
                    }
                } else if (authType == 3) {
                    apiResponse.setBody(CryptoUtils.simpleDecode(this.publicKey, apiResponse.getBody()));
                } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)head)) {
                    apiResponse.setBody(CryptoUtils.aesDecode(CryptoUtils.rsaPubDecode(this.publicKey, head), apiResponse.getBody()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SdkClientException("\u89e3\u5bc6\u5931\u8d25", e);
            }
        }
        return apiResponse;
    }

    private Integer calExpire(String timeUnit, Integer expire) {
        if ("s".equals(timeUnit) || "S".equals(timeUnit)) {
            return expire;
        }
        if ("m".equals(timeUnit) || "M".equals(timeUnit)) {
            return 60 * expire;
        }
        if ("h".equals(timeUnit) || "H".equals(timeUnit)) {
            return 3600 * expire;
        }
        return expire;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        if (!apiClient.isInited()) {
            apiClient.init();
        }
        this.apiClient = apiClient;
    }

    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getEquipmentNo() {
        return this.equipmentNo;
    }

    public void setEquipmentNo(String equipmentNo) {
        this.equipmentNo = equipmentNo;
    }

    public String getSignStrategyUrl() {
        return this.signStrategyUrl;
    }

    public void setSignStrategyUrl(String signStrategyUrl) {
        this.signStrategyUrl = signStrategyUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public boolean isIcloudlockEnabled() {
        return this.icloudlockEnabled;
    }

    public void setIcloudlockEnabled(boolean icloudlockEnabled) {
        this.icloudlockEnabled = icloudlockEnabled;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getGmAppSecret() {
        return this.gmAppSecret;
    }

    public void setGmAppSecret(String gmAppSecret) {
        this.gmAppSecret = gmAppSecret;
    }

    public String getGmPublicKey() {
        return this.gmPublicKey;
    }

    public void setGmPublicKey(String gmPublicKey) {
        this.gmPublicKey = gmPublicKey;
    }

    public String getGmPrivateKey() {
        return this.gmPrivateKey;
    }

    public void setGmPrivateKey(String gmPrivateKey) {
        this.gmPrivateKey = gmPrivateKey;
    }

    public static void main(String[] args) {
        String publicKey = "305C300D06092A864886F70D0101010500034B0030480241008A4EF08F61696E403B9D4C1716942C458F82E8D08C361E16092E09F9890F12E3762310FDC5AEE6804DC180AACF8F8AB52433A8491B6D7504D68B19A32DC6A1CB0203010001";
        String randomKey = "JgUbiktxsjmbLiyk8c+qc6XWtV6vKwsxUaeqUsr58OYEUGrn4/+/0hlV0lwJzyjfmbORATkXSREGSJ6Cexfw4g==";
        String response = "DjWYhkgJ3MLoIYoiouzi0ybDP8pFI3mcX6C4g56EPYN8S3VuW7j0hjePNL1pu2hGoDiGxR0atdLTL9T1cd9a+plJxeUyQnBNZgo813M39sIRpDppo0s4DRiUchhfe9UcIAJuG8xcOr2cznjIrCxIy5TGGiCjiAshLBZy2HBoVqB7K0naPizN16lZG4xpvpILfXI41F8DROf+i/4x1iC7v472EY+34D2QZ8frtEsAyC3AV+oxcXQ/h02X5TVWQ4WIxul+XC3EijPfB6skZdu0qlF65OuRup4M88kpTimUEY8Ear++C+fymEprs0WqQhzQ2RgijSELNdVxwVil6VqEfkPL/Xbh1BjNMBC+3EFYK+8=";
        try {
            String test = new String(CryptoUtils.aesDecode(CryptoUtils.rsaPubDecode(publicKey, randomKey), response.getBytes("UTF-8")));
            System.out.println(test);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

