/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.fsp.shield.java.sdk.http;

import com.iflytek.fsp.shield.java.sdk.exception.SdkClientException;
import com.iflytek.fsp.shield.java.sdk.model.ApiCallback;
import com.iflytek.fsp.shield.java.sdk.model.ApiRequest;
import com.iflytek.fsp.shield.java.sdk.model.ApiResponse;
import com.iflytek.fsp.shield.java.sdk.util.RequestUtil;
import com.iflytek.fsp.shield.java.sdk.util.ResponseUtil;
import java.io.Closeable;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class ApiClient {
    private static final int DEFAULT_MAX_TOTAL_CONN = 200;
    private static final int DEFAULT_MAX_PER_ROUTE_CONN = 20;
    private static final int DEFAULT_CONN_KEEP_LIVE = 0;
    private static final String[] DEFAULT_HTTPS_SUPPORTED_PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
    private static final int DEFAULT_CONN_TIMEOUT_MILLIS = 60000;
    private static final int DEFAULT_READ_TIMEOUT_MILLS = 60000;
    private static final int DEFAULT_WRITE_TIMEOUT_MILLS = 60000;
    private static final long DEFAULT_THREAD_KEEP_LIVE = 60000L;
    private static final int DEFAULT_MAX_THREAD_POOL_SIZE = 10;
    private static final int DEFAULT_CORE_THREAD_POOL_SIZE = 0;
    private CloseableHttpClient httpClient;
    private ExecutorService executorService;
    private PoolingHttpClientConnectionManager connectionManager;
    private boolean inited = false;
    private int maxTotalConn = 200;
    private int maxPerRouteConn = 20;
    private long connKeepLiveMillis = 0L;
    private int coreThreadPoolSize = 0;
    private int maxThreadPoolSize = 10;
    private long threadKeepLiveMillis = 60000L;
    private int connTimeoutMillis = 60000;
    private int readTimeoutMills = 60000;
    private int writeTimeoutMills = 60000;

    private static SSLConnectionSocketFactory createSSLConnSocketFactory(String[] httpsSupportedProtocols) {
        SSLConnectionSocketFactory sslfs = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslfs = new SSLConnectionSocketFactory(sslContext, httpsSupportedProtocols, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return sslfs;
    }

    public void init() {
        this.init(DEFAULT_HTTPS_SUPPORTED_PROTOCOLS, null);
    }

    public void init(String[] httpsSupportedProtocols) {
        this.init(httpsSupportedProtocols, null);
    }

    public void init(HttpHost proxy) {
        this.init(DEFAULT_HTTPS_SUPPORTED_PROTOCOLS, proxy);
    }

    public void init(String[] httpsSupportedProtocols, HttpHost proxy) {
        String sdkConnKeepLiveMillis;
        String maxPerRouteConn;
        HttpClientBuilder builder = HttpClientBuilder.create();
        SSLConnectionSocketFactory sslsf = ApiClient.createSSLConnSocketFactory(httpsSupportedProtocols);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
        String maxTotalConn = RequestUtil.getPropByKey("maxTotalConn");
        if (StringUtils.isNotBlank((CharSequence)maxTotalConn)) {
            try {
                this.maxTotalConn = Integer.valueOf(maxTotalConn);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(maxPerRouteConn = RequestUtil.getPropByKey("maxPerRouteConn")))) {
            try {
                this.maxPerRouteConn = Integer.valueOf(maxPerRouteConn);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(sdkConnKeepLiveMillis = RequestUtil.getPropByKey("connKeepLiveMillis")))) {
            try {
                this.connKeepLiveMillis = Integer.valueOf(sdkConnKeepLiveMillis).intValue();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.connectionManager = new PoolingHttpClientConnectionManager(registry);
        this.connectionManager.setMaxTotal(this.maxTotalConn);
        this.connectionManager.setDefaultMaxPerRoute(this.maxPerRouteConn);
        builder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        if (proxy != null) {
            builder.setProxy(proxy);
        }
        RequestConfig defaultConfig = RequestConfig.custom().setConnectTimeout(this.connTimeoutMillis).setSocketTimeout(this.readTimeoutMills).setConnectionRequestTimeout(this.writeTimeoutMills).build();
        builder.setDefaultRequestConfig(defaultConfig);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        this.executorService = new ThreadPoolExecutor(this.coreThreadPoolSize, this.maxThreadPoolSize, this.threadKeepLiveMillis, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new DeafultAsyncThreadFactory());
        if (this.connKeepLiveMillis > 0L) {
            builder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long duration = DefaultConnectionKeepAliveStrategy.INSTANCE.getKeepAliveDuration(response, context);
                    if (duration > 0L && duration < ApiClient.this.connKeepLiveMillis) {
                        return duration;
                    }
                    return ApiClient.this.connKeepLiveMillis;
                }
            });
        }
        builder.setRetryHandler(new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount > 3) {
                    return false;
                }
                return exception instanceof NoHttpResponseException;
            }
        });
        this.httpClient = builder.build();
        this.inited = true;
    }

    ApiResponse syncRequest(ApiRequest apiRequest) {
        ApiResponse apiResponse;
        CloseableHttpResponse httpResponse = null;
        try {
            HttpUriRequest httpRequest = RequestUtil.parseToHttpRequest(apiRequest);
            httpResponse = this.httpClient.execute(httpRequest);
            apiResponse = ResponseUtil.parseToApiResponse((HttpResponse)httpResponse);
        }
        catch (IOException e) {
            try {
                throw new SdkClientException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(httpResponse);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)httpResponse);
        return apiResponse;
    }

    final Future<ApiResponse> asyncRequest(final ApiRequest apiRequest, final ApiCallback callback) {
        return this.executorService.submit(new Callable<ApiResponse>(){

            @Override
            public ApiResponse call() throws Exception {
                ApiResponse result;
                try {
                    result = ApiClient.this.syncRequest(apiRequest);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onFailure(apiRequest, e);
                    }
                    throw e;
                }
                if (callback != null) {
                    callback.onResponse(apiRequest, result);
                }
                return result;
            }
        });
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public int getMaxTotalConn() {
        return this.maxTotalConn;
    }

    public void setMaxTotalConn(int maxTotalConn) {
        this.maxTotalConn = maxTotalConn;
    }

    public int getMaxPerRouteConn() {
        return this.maxPerRouteConn;
    }

    public void setMaxPerRouteConn(int maxPerRouteConn) {
        this.maxPerRouteConn = maxPerRouteConn;
    }

    public long getConnKeepLiveMillis() {
        return this.connKeepLiveMillis;
    }

    public void setConnKeepLiveMillis(long connKeepLiveMillis) {
        this.connKeepLiveMillis = connKeepLiveMillis;
    }

    public int getCoreThreadPoolSize() {
        return this.coreThreadPoolSize;
    }

    public void setCoreThreadPoolSize(int coreThreadPoolSize) {
        this.coreThreadPoolSize = coreThreadPoolSize;
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public void setMaxThreadPoolSize(int maxThreadPoolSize) {
        this.maxThreadPoolSize = maxThreadPoolSize;
    }

    public long getThreadKeepLiveMillis() {
        return this.threadKeepLiveMillis;
    }

    public void setThreadKeepLiveMillis(long threadKeepLiveMillis) {
        this.threadKeepLiveMillis = threadKeepLiveMillis;
    }

    public int getConnTimeoutMillis() {
        return this.connTimeoutMillis;
    }

    public void setConnTimeoutMillis(int connTimeoutMillis) {
        this.connTimeoutMillis = connTimeoutMillis;
    }

    public int getReadTimeoutMills() {
        return this.readTimeoutMills;
    }

    public void setReadTimeoutMills(int readTimeoutMills) {
        this.readTimeoutMills = readTimeoutMills;
    }

    public int getWriteTimeoutMills() {
        return this.writeTimeoutMills;
    }

    public void setWriteTimeoutMills(int writeTimeoutMills) {
        this.writeTimeoutMills = writeTimeoutMills;
    }

    public PoolingHttpClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(PoolingHttpClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public boolean isInited() {
        return this.inited;
    }

    public void setInited(boolean inited) {
        this.inited = inited;
    }

    private class DeafultAsyncThreadFactory
    implements ThreadFactory {
        private AtomicInteger counter = new AtomicInteger(0);

        private DeafultAsyncThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "Iflytek_Shield_JAVA_SDK_Async_ThreadPool_" + this.counter.incrementAndGet());
        }
    }
}

