/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.fsp.shield.java.sdk.util;

import com.iflytek.fsp.shield.java.sdk.exception.SdkClientException;
import com.iflytek.fsp.shield.java.sdk.icloudlock.CodeManager;
import com.iflytek.fsp.shield.java.sdk.model.ApiRequest;
import com.iflytek.fsp.shield.java.sdk.model.MultiValueAbleHttpParams;
import com.iflytek.fsp.shield.java.sdk.model.MultipartFile;
import com.iflytek.fsp.shield.java.sdk.util.CryptoUtils;
import com.iflytek.fsp.shield.java.sdk.util.MapUtils;
import com.iflytek.fsp.shield.java.sdk.util.Native2AsciiUtils;
import com.iflytek.fsp.shield.java.sdk.util.RandomUtils;
import com.iflytek.fsp.shield.java.sdk.util.SignUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;

public class RequestUtil {
    private static String sdkVersion = null;

    public static HttpUriRequest parseToHttpRequest(ApiRequest apiReq) {
        RequestBuilder builder = RequestBuilder.create((String)apiReq.getMethod().getName());
        builder.setUri(RequestUtil.buildUri(apiReq));
        EntityBuilder bodyBuilder = EntityBuilder.create();
        bodyBuilder.setContentType(ContentType.parse((String)RequestUtil.getContentType(apiReq)));
        if (MapUtils.isNotEmpty(apiReq.getFormParams())) {
            ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
            for (Map.Entry entry : apiReq.getFormParams().entrySet()) {
                for (String val : (List)entry.getValue()) {
                    paramList.add(new BasicNameValuePair((String)entry.getKey(), val));
                }
            }
            bodyBuilder.setParameters(paramList);
            builder.setEntity(bodyBuilder.build());
        } else if (ArrayUtils.isNotEmpty((byte[])apiReq.getBody())) {
            bodyBuilder.setBinary(apiReq.getBody());
            builder.setEntity(bodyBuilder.build());
        } else if (MapUtils.isNotEmpty(apiReq.getMultiFormParams())) {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.setCharset(Charset.forName("UTF-8"));
            multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (Map.Entry entry : apiReq.getMultiFormParams().entrySet()) {
                for (Object value : (List)entry.getValue()) {
                    if (value instanceof MultipartFile) {
                        MultipartFile f = (MultipartFile)value;
                        multipartEntityBuilder.addBinaryBody((String)entry.getKey(), f.getFile(), ContentType.create((String)f.getContentType()), f.getFilename());
                        continue;
                    }
                    if (value instanceof byte[]) {
                        multipartEntityBuilder.addBinaryBody((String)entry.getKey(), (byte[])value);
                        continue;
                    }
                    multipartEntityBuilder.addTextBody((String)entry.getKey(), new String((byte[])value), ContentType.create((String)"text/plain", (Charset)Charset.forName("UTF-8")));
                }
            }
            builder.setEntity(multipartEntityBuilder.build());
        }
        for (Map.Entry entry : apiReq.getHeaders().entrySet()) {
            for (String val : (List)entry.getValue()) {
                if (val == null) continue;
                builder.addHeader((String)entry.getKey(), RequestUtil.encodeHeader(val));
            }
        }
        builder.setCharset(Charset.forName("UTF-8"));
        return builder.build();
    }

    public static ApiRequest buildSdkRequest(ApiRequest apiRequest, String appId, String secret, String stage, boolean icloudlockEnabled) {
        String pathWithPathParameter = RequestUtil.combinePathParam(apiRequest.getPath(), apiRequest.getPathParams());
        apiRequest.setPath(pathWithPathParameter);
        apiRequest.getHeaders().appendOne("S-Auth-Nonce", UUID.randomUUID().toString());
        apiRequest.getHeaders().appendOne("S-Auth-Version", "1");
        apiRequest.getHeaders().appendOne("S-Auth-Timestamp", System.currentTimeMillis() + "");
        apiRequest.getHeaders().appendOne("S-Auth-GroupId", apiRequest.getGroupId());
        apiRequest.getHeaders().appendOne("User-Agent", "ShieldJavaSDK");
        apiRequest.getHeaders().appendOne("S-SDK-Version", RequestUtil.getSdkVersion());
        if (MapUtils.isEmpty(apiRequest.getFormParams()) && ArrayUtils.isNotEmpty((byte[])apiRequest.getBody())) {
            apiRequest.getHeaders().appendOne("S-Content-MD5", SignUtil.md5ThenBase64(apiRequest.getBody()));
        }
        apiRequest.getHeaders().appendOne("S-Auth-Stage", stage);
        apiRequest.getHeaders().appendOne("S-Auth-AppId", appId);
        if (icloudlockEnabled) {
            apiRequest.getHeaders().appendOne("S-Auth-CODE", CodeManager.getInstance().getCode());
        }
        RequestUtil.signRequest(apiRequest, appId, secret);
        return apiRequest;
    }

    public static ApiRequest cryptRequest(ApiRequest apiRequest, String publicKey) {
        try {
            String randomKey = RandomUtils.generateKeyRadom() + "";
            String rsaRandomKey = CryptoUtils.rsaEncode(publicKey, randomKey);
            apiRequest.getHeaders().appendOne("S-Auth-RandomKey", rsaRandomKey);
            if (MapUtils.isNotEmpty(apiRequest.getFormParams())) {
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                for (Map.Entry entry : apiRequest.getFormParams().entrySet()) {
                    for (String val : (List)entry.getValue()) {
                        paramList.add(new BasicNameValuePair((String)entry.getKey(), val));
                    }
                }
                EntityBuilder bodyBuilder = EntityBuilder.create();
                bodyBuilder.setParameters(paramList).setContentType(ContentType.parse((String)RequestUtil.getContentType(apiRequest)));
                HttpEntity httpEntity = bodyBuilder.build();
                byte[] data = new byte[(int)httpEntity.getContentLength()];
                IOUtils.read((InputStream)httpEntity.getContent(), (byte[])data);
                String base64 = CryptoUtils.aesEncode(randomKey, data);
                apiRequest.setFormParams(null);
                apiRequest.setBody(base64.getBytes("UTF-8"));
            } else if (ArrayUtils.isNotEmpty((byte[])apiRequest.getBody())) {
                String base64 = CryptoUtils.aesEncode(randomKey, apiRequest.getBody());
                apiRequest.setBody(base64.getBytes("UTF-8"));
            } else if (MapUtils.isNotEmpty(apiRequest.getMultiFormParams())) {
                MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
                multipartEntityBuilder.setCharset(Charset.forName("UTF-8"));
                multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                for (Map.Entry entry : apiRequest.getMultiFormParams().entrySet()) {
                    Object value = entry.getValue();
                    if (value instanceof MultipartFile) {
                        MultipartFile f = (MultipartFile)value;
                        multipartEntityBuilder.addBinaryBody((String)entry.getKey(), f.getFile(), ContentType.create((String)f.getContentType()), f.getFilename());
                        continue;
                    }
                    multipartEntityBuilder.addTextBody((String)entry.getKey(), new String((byte[])value), ContentType.create((String)"text/plain", (Charset)Charset.forName("UTF-8")));
                }
                HttpEntity httpEntity = multipartEntityBuilder.build();
                ByteArrayOutputStream outstream = new ByteArrayOutputStream();
                httpEntity.writeTo((OutputStream)outstream);
                outstream.flush();
                byte[] data = outstream.toByteArray();
                String base64 = CryptoUtils.aesEncode(randomKey, data);
                apiRequest.getHeaders().appendOne("Content-Type", httpEntity.getContentType().getValue());
                apiRequest.setMultiFormParams(null);
                apiRequest.setBody(base64.getBytes("UTF-8"));
            }
            return apiRequest;
        }
        catch (Exception e) {
            throw new SdkClientException("\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    private static void signRequest(ApiRequest apiRequest, String authAppId, String secret) {
        URI uri = RequestUtil.buildUri(apiRequest);
        String url = uri.getRawPath();
        if (StringUtils.isNotBlank((CharSequence)uri.getRawQuery())) {
            url = url + "?" + uri.getRawQuery();
        }
        String authRandomKey = apiRequest.getHeaders().getOne("S-Auth-RandomKey");
        String authNonce = apiRequest.getHeaders().getOne("S-Auth-Nonce");
        String authTimestamp = apiRequest.getHeaders().getOne("S-Auth-Timestamp");
        String contentMD5 = apiRequest.getHeaders().getOne("S-Content-MD5");
        String signature = SignUtil.sign(secret, url, authRandomKey, authNonce, authTimestamp, authAppId, contentMD5);
        apiRequest.getHeaders().appendOne("S-Auth-Signature", signature);
    }

    private static URI buildUri(ApiRequest apiRequest) {
        try {
            URIBuilder uriBuilder = new URIBuilder();
            uriBuilder.setScheme(apiRequest.getScheme());
            uriBuilder.setHost(apiRequest.getHost());
            uriBuilder.setPath(apiRequest.getPath());
            uriBuilder.setPort(apiRequest.getPort());
            if (MapUtils.isNotEmpty(apiRequest.getQuerys())) {
                for (Map.Entry entry : apiRequest.getQuerys().entrySet()) {
                    for (String val : (List)entry.getValue()) {
                        uriBuilder.addParameter((String)entry.getKey(), val);
                    }
                }
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new SdkClientException("build http request uri failed", e);
        }
    }

    private static String combinePathParam(String path, MultiValueAbleHttpParams<String> pathParams) {
        if (pathParams == null) {
            return path;
        }
        for (String key : pathParams.keySet()) {
            for (String val : (List)pathParams.get(key)) {
                path = path.replace("[" + key + "]", val);
            }
        }
        return path;
    }

    private static String getContentType(ApiRequest apiRequest) {
        String userSetHeader = apiRequest.getHeaders().getOne("Content-Type");
        if (userSetHeader != null) {
            return userSetHeader;
        }
        if (apiRequest.getBody() != null) {
            return "application/octet-stream; charset=UTF-8";
        }
        if (apiRequest.getFormParams() != null && apiRequest.getFormParams().size() > 0) {
            return "application/x-www-form-urlencoded; charset=UTF-8";
        }
        if (apiRequest.getMultiFormParams() != null && apiRequest.getMultiFormParams().size() > 0) {
            return "multipart/form-data";
        }
        return "application/json; charset=UTF-8";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSdkVersion() {
        if (sdkVersion == null) {
            URL url = RequestUtil.class.getClassLoader().getResource("build.properties");
            System.out.println("load properties from " + url.getPath());
            Properties properties = new Properties();
            InputStream is = null;
            try {
                is = RequestUtil.class.getClassLoader().getResourceAsStream("build.properties");
                properties.load(is);
                sdkVersion = properties.getProperty("sdk.vesion");
            }
            catch (IOException e) {
                e.printStackTrace();
                sdkVersion = "unknown version";
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return sdkVersion;
    }

    private static String encodeHeader(String header) {
        return Native2AsciiUtils.native2Ascii(header);
    }
}

