/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.fsp.shield.java.sdk.util;

import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class CryptoUtils {
    public static final String KEY_ALGORITHM_RSA = "RSA";
    public static final String KEY_ALGORITHM_AES = "AES";
    public static final String CIPHER_ALGORITHM_AES = "AES/CBC/PKCS5Padding";
    public static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";
    public static final int KEY_SIZE_RSA = 512;
    public static final int KEY_SIZE_AES = 128;

    public static String aesEncode(String key, String plainText) throws Exception {
        return CryptoUtils.aesEncode(key, plainText.getBytes("UTF-8"));
    }

    public static String aesEncode(String key, byte[] data) throws Exception {
        String aesKey = CryptoUtils.getAesKey(key);
        byte[] enCodeFormat = aesKey.getBytes("UTF-8");
        SecretKeySpec secretKeySpec = new SecretKeySpec(enCodeFormat, KEY_ALGORITHM_AES);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_AES);
        cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(new byte[16]));
        byte[] result = cipher.doFinal(data);
        return Base64.encodeBase64String((byte[])result);
    }

    public static byte[] aesDecode(String key, byte[] content) throws Exception {
        String aesKey = CryptoUtils.getAesKey(key);
        byte[] enCodeFormat = aesKey.getBytes("UTF-8");
        SecretKeySpec secretKeySpec = new SecretKeySpec(enCodeFormat, KEY_ALGORITHM_AES);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_AES);
        cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(new byte[16]));
        byte[] result = cipher.doFinal(Base64.decodeBase64((byte[])content));
        return result;
    }

    public static String rsaEncode(String publicKey, String plainText) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, CryptoUtils.restorePublicKey(CryptoUtils.hexStringToBytes(publicKey)));
        byte[] ci = cipher.doFinal(plainText.getBytes("UTF-8"));
        return Base64.encodeBase64String((byte[])ci);
    }

    public static String rsaPubDecode(String publicKey, String encodedText) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, CryptoUtils.restorePublicKey(CryptoUtils.hexStringToBytes(publicKey)));
        return new String(cipher.doFinal(Base64.decodeBase64((String)encodedText)), "UTF-8");
    }

    private static String getAesKey(String str) throws Exception {
        MessageDigest messageDigest = null;
        messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        messageDigest.update(str.getBytes("UTF-8"));
        byte[] byteArray = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        md5StrBuff.append(CryptoUtils.bytesToHexString(byteArray));
        return md5StrBuff.substring(8, 24).toLowerCase();
    }

    public static PublicKey restorePublicKey(byte[] keyBytes) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        PublicKey publicKey = factory.generatePublic(x509EncodedKeySpec);
        return publicKey;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v).toUpperCase();
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(CryptoUtils.charToByte(hexChars[pos]) << 4 | CryptoUtils.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

