/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.fsp.shield.java.sdk.model;

import com.iflytek.fsp.shield.java.sdk.enums.Method;
import com.iflytek.fsp.shield.java.sdk.enums.ParamPosition;
import com.iflytek.fsp.shield.java.sdk.exception.SdkClientException;
import com.iflytek.fsp.shield.java.sdk.model.MultiValueAbleHttpParams;
import com.iflytek.fsp.shield.java.sdk.model.MultipartFile;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class ApiRequest
implements Serializable {
    private static final long serialVersionUID = 5736536680650635945L;
    private String scheme;
    private Method method;
    private String host;
    private int port;
    protected String groupId;
    private int authType;
    private String path;
    private String tokenValue;
    private MultiValueAbleHttpParams<String> pathParams = new MultiValueAbleHttpParams();
    private MultiValueAbleHttpParams<String> headers = new MultiValueAbleHttpParams();
    private MultiValueAbleHttpParams<String> querys = new MultiValueAbleHttpParams();
    private MultiValueAbleHttpParams<String> formParams = new MultiValueAbleHttpParams();
    private MultiValueAbleHttpParams<Object> multiFormParams = new MultiValueAbleHttpParams();
    private byte[] body;

    public ApiRequest(String scheme, Method method, String path, int authType, String groupId) {
        this.scheme = scheme;
        this.method = method;
        this.path = path;
        this.authType = authType;
        this.groupId = groupId;
    }

    public void addParam(String name, Object value, ParamPosition position, boolean isRequired) {
        if (value == null) {
            if (isRequired) {
                throw new SdkClientException(String.format("param %s is not nullable, please check your codes", name));
            }
            return;
        }
        MultiValueAbleHttpParams<Object> targetParamMap = null;
        switch (position) {
            case HEADER: {
                targetParamMap = this.headers;
                break;
            }
            case PATH: {
                targetParamMap = this.pathParams;
                break;
            }
            case QUERY: {
                targetParamMap = this.querys;
                break;
            }
            case FORM: {
                targetParamMap = this.formParams;
                break;
            }
            case MULTIFORM: {
                targetParamMap = this.multiFormParams;
                break;
            }
            default: {
                throw new SdkClientException("unknown param position: " + (Object)((Object)position));
            }
        }
        if (position == ParamPosition.HEADER || position == ParamPosition.PATH || position == ParamPosition.QUERY || position == ParamPosition.FORM) {
            if (value instanceof String) {
                targetParamMap.appendOne(name, (String)value);
            } else {
                targetParamMap.appendOne(name, value.toString());
            }
        }
        if (position == ParamPosition.MULTIFORM) {
            if (value instanceof byte[]) {
                targetParamMap.appendOne(name, value);
            } else if (value instanceof MultipartFile) {
                this.addFile(name, (MultipartFile)value, isRequired);
            } else {
                try {
                    targetParamMap.appendOne(name, value.toString().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new SdkClientException("unsupport UTF-8 encoding for value: " + value);
                }
            }
        }
    }

    public void addFile(String name, MultipartFile value, boolean isRequired) {
        if (value == null) {
            if (isRequired) {
                throw new SdkClientException(String.format("param %s is not nullable, please check your codes", name));
            }
            return;
        }
        MultiValueAbleHttpParams<Object> targetParamMap = this.multiFormParams;
        if (!(value instanceof MultipartFile)) {
            throw new SdkClientException("value must be file: " + value);
        }
        targetParamMap.appendOne(name, value);
    }

    public String getScheme() {
        return this.scheme;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public MultiValueAbleHttpParams<String> getPathParams() {
        return this.pathParams;
    }

    public MultiValueAbleHttpParams<String> getHeaders() {
        return this.headers;
    }

    public MultiValueAbleHttpParams<String> getQuerys() {
        return this.querys;
    }

    public MultiValueAbleHttpParams<String> getFormParams() {
        return this.formParams;
    }

    public MultiValueAbleHttpParams<Object> getMultiFormParams() {
        return this.multiFormParams;
    }

    public void setMultiFormParams(MultiValueAbleHttpParams<Object> multiFormParams) {
        this.multiFormParams = multiFormParams;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String toString() {
        return "ApiRequest{scheme=" + this.scheme + ", method=" + (Object)((Object)this.method) + ", host='" + this.host + '\'' + ", path='" + this.path + '\'' + ", pathParams=" + this.pathParams + ", headers=" + this.headers + ", querys=" + this.querys + ", formParams=" + this.formParams + ", body=" + Arrays.toString(this.body) + '}';
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPathParams(MultiValueAbleHttpParams<String> pathParams) {
        this.pathParams = pathParams;
    }

    public void setHeaders(MultiValueAbleHttpParams<String> headers) {
        this.headers = headers;
    }

    public void setQuerys(MultiValueAbleHttpParams<String> querys) {
        this.querys = querys;
    }

    public void setFormParams(MultiValueAbleHttpParams<String> formParams) {
        this.formParams = formParams;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getAuthType() {
        return this.authType;
    }

    public void setAuthType(int authType) {
        this.authType = authType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public void setTokenValue(String tokenValue) {
        this.tokenValue = tokenValue;
    }
}

