/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxPooledConnection;
import com.informix.jdbcx.IfxReUsableConnection;
import java.sql.SQLException;
import java.util.Properties;

public class IfxSqliConnReUsableConnection
extends IfxSqliConnect
implements IfxReUsableConnection {
    private IfxPooledConnection parentPoolConn = null;
    private String ldbName;
    private String connUser;
    private String connPasswd;

    public IfxSqliConnReUsableConnection() throws SQLException {
        this.ldbName = null;
    }

    public IfxSqliConnReUsableConnection(String luser, String lpasswd, IfxPooledConnection fromWhom, String url, Properties prop, String dbname) throws SQLException {
        super(luser, lpasswd, url, prop);
        this.parentPoolConn = fromWhom;
        this.connUser = luser;
        this.connPasswd = lpasswd;
        if (dbname != null) {
            this.ldbName = dbname;
            this.proto.executeOpenDatabase(this.ldbName, 0);
            this.setServerIsolationLevel();
        }
    }

    String getConnUser() {
        return this.connUser;
    }

    String getConnPasswd() {
        return this.connPasswd;
    }

    @Override
    public void close() throws SQLException {
        if (this.ldbName != null) {
            try {
                this.closeAllResultSets();
                this.clearTransactions(false);
                this.closeAllStatements();
                this.resetDatabaseProperties();
            }
            catch (SQLException e) {
                if (this.parentPoolConn != null) {
                    this.parentPoolConn.notifyListenersOfErrors(e);
                }
                throw e;
            }
        }
        this.parentPoolConn.notifyListeners();
        this.softCloseDone = true;
    }

    @Override
    public void hardClose() throws SQLException {
        super.close();
    }
}

