/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper.call;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.mapper.annotation.CallOutBean;
import org.beetl.sql.mapper.annotation.CallParam;
import org.beetl.sql.mapper.call.InConfig;
import org.beetl.sql.mapper.call.OutBeanConfig;

public class CallParameterParser {
    OutBeanConfig outBeanConfig = null;
    InConfig inConfig = new InConfig();

    public CallParameterParser(Method method) {
        this.parseConfig(method);
    }

    public void parseConfig(Method method) {
        InConfig inConfig = new InConfig();
        Parameter[] paraConfig = method.getParameters();
        int i = 0;
        for (Parameter parameter : paraConfig) {
            CallOutBean callOutBean = parameter.getAnnotation(CallOutBean.class);
            if (callOutBean != null) {
                this.outBeanConfig = this.parseOutBeanConfig(parameter);
                this.outBeanConfig.setParamIndex(i);
                ++i;
                continue;
            }
            CallParam callparam = parameter.getAnnotation(CallParam.class);
            this.addCallInParameter(parameter, i, callparam);
            ++i;
        }
    }

    OutBeanConfig parseOutBeanConfig(Parameter parameter) {
        Class<?> type = parameter.getType();
        OutBeanConfig outBeanConfig = new OutBeanConfig();
        outBeanConfig.setBean(type);
        try {
            PropertyDescriptor[] allPs;
            for (PropertyDescriptor ps : allPs = BeanKit.propertyDescriptors(type)) {
                CallParam callParamAnno;
                if (ps.getReadMethod().getDeclaringClass() == Object.class || (callParamAnno = (CallParam)BeanKit.getAnnotation(type, (String)ps.getName(), CallParam.class)) == null) continue;
                Integer jdbcType = callParamAnno.jdbcType();
                Integer callOutIndex = callParamAnno.value();
                if (callOutIndex == null) {
                    throw new IllegalArgumentException("\u9700\u8981\u6307\u660e\u7d22\u5f15 " + type + " \u5c5e\u6027 " + ps.getName());
                }
                outBeanConfig.getIndexJdbcMap().put(callOutIndex, jdbcType == Integer.MAX_VALUE ? null : jdbcType);
                outBeanConfig.getIndexMap().put(callOutIndex, ps.getName());
                outBeanConfig.getIndexTypeMap().put(callOutIndex, ps.getPropertyType());
            }
            return outBeanConfig;
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }

    void addCallInParameter(Parameter parameter, int paramIndex, CallParam callParamAnno) {
        Integer callInIndex;
        Integer jdbcType;
        if (callParamAnno == null) {
            jdbcType = null;
            callInIndex = paramIndex + 1;
        } else {
            jdbcType = callParamAnno.jdbcType();
            callInIndex = callParamAnno.value();
            if (callInIndex == null) {
                callInIndex = paramIndex + 1;
            }
        }
        Class<?> type = parameter.getType();
        this.inConfig.getArgPositionMap().put(paramIndex, callInIndex);
        this.inConfig.getArgJdbcTypeMap().put(paramIndex, jdbcType == null || jdbcType == Integer.MAX_VALUE ? null : jdbcType);
        this.inConfig.getArgType().put(paramIndex, type);
    }

    public OutBeanConfig getOutBeanConfig() {
        return this.outBeanConfig;
    }

    public InConfig getInConfig() {
        return this.inConfig;
    }

    public void setOutBeanConfig(OutBeanConfig outBeanConfig) {
        this.outBeanConfig = outBeanConfig;
    }

    public void setInConfig(InConfig inConfig) {
        this.inConfig = inConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallParameterParser)) {
            return false;
        }
        CallParameterParser other = (CallParameterParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OutBeanConfig this$outBeanConfig = this.getOutBeanConfig();
        OutBeanConfig other$outBeanConfig = other.getOutBeanConfig();
        if (this$outBeanConfig == null ? other$outBeanConfig != null : !((Object)this$outBeanConfig).equals(other$outBeanConfig)) {
            return false;
        }
        InConfig this$inConfig = this.getInConfig();
        InConfig other$inConfig = other.getInConfig();
        return !(this$inConfig == null ? other$inConfig != null : !((Object)this$inConfig).equals(other$inConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallParameterParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OutBeanConfig $outBeanConfig = this.getOutBeanConfig();
        result = result * 59 + ($outBeanConfig == null ? 43 : ((Object)$outBeanConfig).hashCode());
        InConfig $inConfig = this.getInConfig();
        result = result * 59 + ($inConfig == null ? 43 : ((Object)$inConfig).hashCode());
        return result;
    }

    public String toString() {
        return "CallParameterParser(outBeanConfig=" + this.getOutBeanConfig() + ", inConfig=" + this.getInConfig() + ")";
    }
}

