/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.fetch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.beetl.sql.fetch.AttributeKey;
import org.beetl.sql.fetch.Key;

public class FetchContext {
    int level = 1;
    Map<Class, Map<Key, Object>> loadedCache = new HashMap<Class, Map<Key, Object>>();
    Set<AttributeKey> attributeKeys = new HashSet<AttributeKey>();

    public void add(Class target, Object key, Object value) {
        Map<Key, Object> map = this.loadedCache.get(target);
        if (map == null) {
            map = new HashMap<Key, Object>();
            this.loadedCache.put(target, map);
        }
        map.put(new Key(key), value);
    }

    public Object find(Class target, Object key) {
        Map<Key, Object> map = this.loadedCache.get(target);
        if (map == null) {
            return null;
        }
        return map.get(new Key(key));
    }

    public void addAttribute(Object obj, String attrName) {
        AttributeKey attributeKey = new AttributeKey(obj, attrName);
        if (this.attributeKeys.contains(attributeKey)) {
            return;
        }
        this.attributeKeys.add(attributeKey);
    }

    public boolean containAttribute(Object obj, String attrName) {
        AttributeKey attributeKey = new AttributeKey(obj, attrName);
        return this.attributeKeys.contains(attributeKey);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

