/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.fetch;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.fetch.DefaultBeanFetch;
import org.beetl.sql.fetch.FetchAction;
import org.beetl.sql.fetch.FetchContext;

public abstract class AbstractFetchAction
implements FetchAction {
    Annotation annotation;
    PropertyDescriptor originProperty;
    Class owner;
    Class target;

    public Object queryFromCache(Class target, Object key) {
        FetchContext context = DefaultBeanFetch.local.get();
        Object cached = context.find(target, key);
        return cached;
    }

    public Object queryFromCache(Class target, Object value, PropertyDescriptor idProperty) {
        try {
            Object key = idProperty.getReadMethod().invoke(value, new Object[0]);
            return this.queryFromCache(target, key);
        }
        catch (Exception e) {
            throw new BeetlSQLException(16, (Throwable)e);
        }
    }

    public Object queryFromCache(SQLManager sqlManager, Object value) {
        try {
            Class<?> target = value.getClass();
            String attr = sqlManager.getClassDesc(target).getIdAttr();
            Object key = BeanKit.getBeanProperty((Object)value, (String)attr);
            return this.queryFromCache(target, key);
        }
        catch (Exception e) {
            throw new BeetlSQLException(16, (Throwable)e);
        }
    }

    public void addCached(SQLManager sqlManager, Object obj) {
        Class<?> target = obj.getClass();
        String attr = sqlManager.getClassDesc(target).getIdAttr();
        Object key = BeanKit.getBeanProperty((Object)obj, (String)attr);
        this.addCached(obj, key);
    }

    public void addCached(Object value, Object key) {
        FetchContext context = DefaultBeanFetch.local.get();
        context.add(value.getClass(), key, value);
    }

    public void addAttribute(Object obj, String attrName) {
        FetchContext context = DefaultBeanFetch.local.get();
        context.addAttribute(obj, attrName);
    }

    public boolean containAttribute(Object obj, String attrName) {
        FetchContext context = DefaultBeanFetch.local.get();
        return context.containAttribute(obj, attrName);
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public void init(Class owner, Class target, Annotation config, PropertyDescriptor originProperty) {
        this.owner = owner;
        this.target = target;
        this.annotation = config;
        this.originProperty = originProperty;
    }

    @Override
    public PropertyDescriptor getOriginProperty() {
        return this.originProperty;
    }
}

