/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.nosql;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.Set;
import org.beetl.sql.annotation.entity.AssignID;
import org.beetl.sql.annotation.entity.AutoID;
import org.beetl.sql.annotation.entity.Column;
import org.beetl.sql.annotation.entity.SeqID;
import org.beetl.sql.annotation.entity.Table;
import org.beetl.sql.clazz.ColDesc;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.JavaType;
import org.beetl.sql.clazz.kit.ThreadSafeCaseInsensitiveHashMap;
import org.beetl.sql.core.meta.MetadataManager;

public class NoSchemaMetaDataManager
implements MetadataManager {
    protected ThreadSafeCaseInsensitiveHashMap tableInfoMap = new ThreadSafeCaseInsensitiveHashMap();
    protected TableDesc NOT_EXIST = new TableDesc("$$$NOT_EXIST", "");

    public NoSchemaMetaDataManager() {
    }

    public NoSchemaMetaDataManager(List<Class> beans) {
        beans.forEach(bean -> this.parseBean((Class)bean));
    }

    public void addBean(Class bean) {
        this.parseBean(bean);
    }

    protected void parseBean(Class bean) {
        Table table = (Table)BeanKit.getAnnotation((Class)bean, Table.class);
        if (table == null) {
            throw new NullPointerException(bean + " \u9700\u8981\u6ce8\u89e3 @Table");
        }
        TableDesc tableDesc = new TableDesc(table.name(), bean.getName());
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor ps : propertyDescriptors = BeanKit.propertyDescriptors((Class)bean)) {
                Column column = (Column)BeanKit.getAnnotation((Class)bean, (String)ps.getName(), Column.class);
                if (column == null) continue;
                String colName = column.value();
                Class<?> type = ps.getPropertyType();
                ColDesc colDesc = new ColDesc(colName);
                this.initSqlType(colDesc, type);
                tableDesc.addCols(colDesc);
                AssignID assignID = (AssignID)BeanKit.getAnnotation((Class)bean, (String)ps.getName(), AssignID.class);
                if (assignID != null) {
                    tableDesc.addIdName(column.value());
                    continue;
                }
                AutoID autoID = (AutoID)BeanKit.getAnnotation((Class)bean, (String)ps.getName(), AutoID.class);
                if (autoID != null) {
                    tableDesc.addIdName(column.value());
                    continue;
                }
                SeqID seqID = (SeqID)BeanKit.getAnnotation((Class)bean, (String)ps.getName(), SeqID.class);
                if (seqID == null) continue;
                tableDesc.addIdName(column.value());
            }
            this.tableInfoMap.put(tableDesc.getName(), (Object)tableDesc);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    protected void initSqlType(ColDesc colDesc, Class type) {
        Integer jdbcType = (Integer)JavaType.javaTypeJdbcs.get(type);
        if (jdbcType == null) {
            if (type == Double.class || type == Float.class || type == Double.TYPE || type == Float.TYPE) {
                jdbcType = 2;
            }
            jdbcType = 1111;
        }
        colDesc.setSqlType(jdbcType);
    }

    @Override
    public boolean existTable(String tableName) {
        return this.tableInfoMap.containsKey((Object)tableName);
    }

    @Override
    public TableDesc getTable(String name) {
        return (TableDesc)this.tableInfoMap.get((Object)name);
    }

    @Override
    public Set<String> allTable() {
        return this.tableInfoMap.keySet();
    }

    @Override
    public void addTableVirtual(String realTable, String virtual) {
        throw new UnsupportedOperationException("\u5f85\u5b8c\u6210");
    }
}

